/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.rational;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.ModularDivision;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.OrderedField;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class RationalAlgebra
implements OrderedField<RationalAlgebra, RationalMember>,
Scale<RationalMember, RationalMember>,
Norm<RationalMember, RationalMember>,
ScaleByHighPrec<RationalMember>,
ScaleByRational<RationalMember>,
ModularDivision<RationalMember>,
Tolerance<RationalMember, RationalMember> {
    private final Function2<Boolean, RationalMember, RationalMember> EQ = new Function2<Boolean, RationalMember, RationalMember>(){

        @Override
        public Boolean call(RationalMember a, RationalMember b) {
            return a.n.equals(b.n) && a.d.equals(b.d);
        }
    };
    private final Function2<Boolean, RationalMember, RationalMember> NEQ = new Function2<Boolean, RationalMember, RationalMember>(){

        @Override
        public Boolean call(RationalMember a, RationalMember b) {
            return RationalAlgebra.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<RationalMember, RationalMember> ASS = new Procedure2<RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b) {
            b.set(a);
        }
    };
    private final Function1<Boolean, RationalMember> ISZER = new Function1<Boolean, RationalMember>(){

        @Override
        public Boolean call(RationalMember a) {
            return a.n.signum() == 0;
        }
    };
    private final Procedure1<RationalMember> ZER = new Procedure1<RationalMember>(){

        @Override
        public void call(RationalMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<RationalMember, RationalMember> NEG = new Procedure2<RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b) {
            b.n = a.n.negate();
            b.d = a.d;
        }
    };
    private final Procedure3<RationalMember, RationalMember, RationalMember> ADD = new Procedure3<RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember c) {
            BigInteger n = a.n.multiply(b.d).add(b.n.multiply(a.d));
            BigInteger d = a.d.multiply(b.d);
            c.setV(n, d);
        }
    };
    private final Procedure3<RationalMember, RationalMember, RationalMember> SUB = new Procedure3<RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember c) {
            BigInteger n = a.n.multiply(b.d).subtract(b.n.multiply(a.d));
            BigInteger d = a.d.multiply(b.d);
            c.setV(n, d);
        }
    };
    private final Procedure3<RationalMember, RationalMember, RationalMember> MUL = new Procedure3<RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember c) {
            BigInteger n = a.n.multiply(b.n);
            BigInteger d = a.d.multiply(b.d);
            c.setV(n, d);
        }
    };
    private final Procedure3<RationalMember, RationalMember, RationalMember> DIVIDE = new Procedure3<RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember c) {
            BigInteger n = a.n.multiply(b.d);
            BigInteger d = a.d.multiply(b.n);
            c.setV(n, d);
        }
    };
    private final Procedure3<RationalMember, RationalMember, RationalMember> DIV = new Procedure3<RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember d) {
            RationalMember tmp = G.RAT.construct();
            RationalAlgebra.this.divide().call(a, b, tmp);
            BigDecimal untruncated = tmp.v();
            d.setV(untruncated.toBigInteger());
        }
    };
    private final Procedure3<RationalMember, RationalMember, RationalMember> MOD = new Procedure3<RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember m) {
            RationalMember d = G.RAT.construct();
            RationalMember tmp = G.RAT.construct();
            RationalAlgebra.this.div().call(a, b, d);
            RationalAlgebra.this.multiply().call(b, d, tmp);
            RationalAlgebra.this.subtract().call(a, tmp, m);
        }
    };
    private final Procedure4<RationalMember, RationalMember, RationalMember, RationalMember> DIVMOD = new Procedure4<RationalMember, RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember d, RationalMember m) {
            RationalMember tmp = G.RAT.construct();
            RationalMember tmpD = G.RAT.construct();
            RationalAlgebra.this.divide().call(a, b, tmp);
            BigDecimal untruncated = tmp.v();
            tmpD.setV(untruncated.toBigInteger());
            RationalAlgebra.this.multiply().call(b, tmpD, tmp);
            RationalAlgebra.this.subtract().call(a, tmp, m);
            RationalAlgebra.this.assign().call(tmpD, d);
        }
    };
    private final Procedure3<Integer, RationalMember, RationalMember> POWER = new Procedure3<Integer, RationalMember, RationalMember>(){

        @Override
        public void call(Integer power, RationalMember a, RationalMember b) {
            PowerAny.compute(G.RAT, power, a, b);
        }
    };
    private final Procedure1<RationalMember> UNITY = new Procedure1<RationalMember>(){

        @Override
        public void call(RationalMember a) {
            a.n = BigInteger.ONE;
            a.d = BigInteger.ONE;
        }
    };
    private final Procedure2<RationalMember, RationalMember> INV = new Procedure2<RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b) {
            b.setV(a.d, a.n);
        }
    };
    private Function2<Boolean, RationalMember, RationalMember> LESS = new Function2<Boolean, RationalMember, RationalMember>(){

        @Override
        public Boolean call(RationalMember a, RationalMember b) {
            return RationalAlgebra.this.compare().call(a, b) < 0;
        }
    };
    private Function2<Boolean, RationalMember, RationalMember> LEQ = new Function2<Boolean, RationalMember, RationalMember>(){

        @Override
        public Boolean call(RationalMember a, RationalMember b) {
            return RationalAlgebra.this.compare().call(a, b) <= 0;
        }
    };
    private Function2<Boolean, RationalMember, RationalMember> GREAT = new Function2<Boolean, RationalMember, RationalMember>(){

        @Override
        public Boolean call(RationalMember a, RationalMember b) {
            return RationalAlgebra.this.compare().call(a, b) > 0;
        }
    };
    private Function2<Boolean, RationalMember, RationalMember> GEQ = new Function2<Boolean, RationalMember, RationalMember>(){

        @Override
        public Boolean call(RationalMember a, RationalMember b) {
            return RationalAlgebra.this.compare().call(a, b) >= 0;
        }
    };
    private final Function2<Integer, RationalMember, RationalMember> CMP = new Function2<Integer, RationalMember, RationalMember>(){

        @Override
        public Integer call(RationalMember a, RationalMember b) {
            return a.n.multiply(b.d).compareTo(b.n.multiply(a.d));
        }
    };
    private final Function1<Integer, RationalMember> SIG = new Function1<Integer, RationalMember>(){

        @Override
        public Integer call(RationalMember a) {
            return a.n.signum();
        }
    };
    private final Procedure3<RationalMember, RationalMember, RationalMember> MIN = new Procedure3<RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember c) {
            Min.compute(G.RAT, a, b, c);
        }
    };
    private final Procedure3<RationalMember, RationalMember, RationalMember> MAX = new Procedure3<RationalMember, RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b, RationalMember c) {
            Max.compute(G.RAT, a, b, c);
        }
    };
    private final Procedure2<RationalMember, RationalMember> ABS = new Procedure2<RationalMember, RationalMember>(){

        @Override
        public void call(RationalMember a, RationalMember b) {
            b.n = a.n.abs();
            b.d = a.d;
        }
    };
    private final Procedure3<HighPrecisionMember, RationalMember, RationalMember> SBHP = new Procedure3<HighPrecisionMember, RationalMember, RationalMember>(){

        @Override
        public void call(HighPrecisionMember a, RationalMember b, RationalMember c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.n()));
            c.setV(tmp.toBigInteger(), b.d());
        }
    };
    private final Function3<Boolean, RationalMember, RationalMember, RationalMember> WITHIN = new Function3<Boolean, RationalMember, RationalMember, RationalMember>(){

        @Override
        public Boolean call(RationalMember tol, RationalMember a, RationalMember b) {
            return NumberWithin.compute(G.RAT, tol, a, b);
        }
    };

    @Override
    public RationalMember construct() {
        return new RationalMember();
    }

    @Override
    public RationalMember construct(RationalMember other) {
        return new RationalMember(other);
    }

    @Override
    public RationalMember construct(String str) {
        return new RationalMember(str);
    }

    @Override
    public Function2<Boolean, RationalMember, RationalMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, RationalMember, RationalMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<RationalMember, RationalMember> assign() {
        return this.ASS;
    }

    @Override
    public Function1<Boolean, RationalMember> isZero() {
        return this.ISZER;
    }

    @Override
    public Procedure1<RationalMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<RationalMember, RationalMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<RationalMember, RationalMember, RationalMember, RationalMember> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<Integer, RationalMember, RationalMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<RationalMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<RationalMember, RationalMember> invert() {
        return this.INV;
    }

    @Override
    public Function2<Boolean, RationalMember, RationalMember> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, RationalMember, RationalMember> isLessEqual() {
        return this.LEQ;
    }

    @Override
    public Function2<Boolean, RationalMember, RationalMember> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, RationalMember, RationalMember> isGreaterEqual() {
        return this.GEQ;
    }

    @Override
    public Function2<Integer, RationalMember, RationalMember> compare() {
        return this.CMP;
    }

    @Override
    public Function1<Integer, RationalMember> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> max() {
        return this.MAX;
    }

    @Override
    public Procedure2<RationalMember, RationalMember> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<RationalMember, RationalMember> norm() {
        return this.ABS;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, RationalMember, RationalMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, RationalMember, RationalMember> scaleByRational() {
        return this.MUL;
    }

    @Override
    public Function3<Boolean, RationalMember, RationalMember, RationalMember> within() {
        return this.WITHIN;
    }
}

