/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.rational;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.BigIntegerCoder;

public class RationalMember
implements BigIntegerCoder,
Allocatable<RationalMember>,
Duplicatable<RationalMember>,
Settable<RationalMember>,
Gettable<RationalMember>,
UniversalRepresentation,
NumberMember<RationalMember>,
PrimitiveConversion {
    private static final int PLACES = 24;
    private static final MathContext MC = new MathContext(24);
    private static final BigInteger SHIFT = BigInteger.TEN.pow(24);
    private static final BigDecimal SHIFTBD = new BigDecimal(SHIFT);
    BigInteger n;
    BigInteger d;

    public RationalMember() {
        this.primitiveInit();
    }

    public RationalMember(RationalMember other) {
        this.set(other);
    }

    public RationalMember(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        this.setV(val.r());
    }

    public RationalMember(BigInteger integer) {
        this.setV(integer);
    }

    public RationalMember(long integer) {
        this.setV(BigInteger.valueOf(integer));
    }

    public RationalMember(BigInteger n, BigInteger d) {
        this.setV(n, d);
    }

    public RationalMember(long n, long d) {
        this.setV(BigInteger.valueOf(n), BigInteger.valueOf(d));
    }

    @Override
    public void v(RationalMember value) {
        value.set(this);
    }

    @Override
    public void setV(RationalMember value) {
        this.set(value);
    }

    public BigDecimal v() {
        return new BigDecimal(this.n).divide(new BigDecimal(this.d), MC);
    }

    public BigInteger n() {
        return this.n;
    }

    public BigInteger d() {
        return this.d;
    }

    @Override
    public void setV(BigDecimal v) {
        this.setV(v.multiply(SHIFTBD, MC).toBigInteger(), SHIFT);
    }

    @Override
    public void setV(BigInteger n) {
        this.n = n;
        this.d = BigInteger.ONE;
    }

    public void setV(BigInteger n, BigInteger d) {
        int signum = d.signum();
        if (signum == 0) {
            throw new IllegalArgumentException("divide by zero");
        }
        if (signum < 0) {
            n = n.negate();
            d = d.negate();
        }
        if (n.signum() == 0) {
            this.primitiveInit();
        } else {
            BigInteger gcd = n.gcd(d);
            this.n = n.divide(gcd);
            this.d = d.divide(gcd);
        }
    }

    @Override
    public void get(RationalMember other) {
        other.n = this.n;
        other.d = this.d;
    }

    @Override
    public void set(RationalMember other) {
        this.n = other.n;
        this.d = other.d;
    }

    @Override
    public RationalMember duplicate() {
        return new RationalMember(this);
    }

    @Override
    public RationalMember allocate() {
        return new RationalMember();
    }

    public String toString() {
        return this.n.toString() + "/" + this.d.toString();
    }

    @Override
    public int bigIntegerCount() {
        return 2;
    }

    @Override
    public void fromBigIntegerArray(BigInteger[] arr, int index) {
        BigInteger numer = arr[index];
        BigInteger denom = arr[index + 1];
        this.setV(numer, denom);
    }

    @Override
    public void toBigIntegerArray(BigInteger[] arr, int index) {
        arr[index] = this.n;
        arr[index + 1] = this.d;
    }

    @Override
    public long dimension(int d) {
        return 0L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(this.v()));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        this.setV(rep.getValue().r());
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BIGDECIMAL;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        this.setV(BigInteger.valueOf(v));
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        this.setV(BigInteger.valueOf(v));
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        this.setV(BigInteger.valueOf(v));
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        this.setV(BigInteger.valueOf(v));
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        this.setV(BigDecimal.valueOf(v));
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        this.setV(BigDecimal.valueOf(v));
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        this.setV(v);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(BigInteger.valueOf(v));
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(BigInteger.valueOf(v));
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(BigInteger.valueOf(v));
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(BigInteger.valueOf(v));
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            this.setV(v);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().byteValue();
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().shortValue();
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().intValue();
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().longValue();
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().floatValue();
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().doubleValue();
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v().toBigInteger();
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            return this.v();
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v().byteValue();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v().shortValue();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        return this.v().intValue();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        return this.v().longValue();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        return this.v().floatValue();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        return this.v().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        return this.v().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        return this.v();
    }

    @Override
    public void primitiveInit() {
        this.n = BigInteger.ZERO;
        this.d = BigInteger.ONE;
    }
}

