/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.rgb;

import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.data.rgb.ArgbMember;
import nom.bdezonia.zorbage.type.data.rgb.RgbUtils;

public class ArgbAlgebra
implements Algebra<ArgbAlgebra, ArgbMember>,
Bounded<ArgbMember>,
Random<ArgbMember> {
    private final Function2<Boolean, ArgbMember, ArgbMember> EQ = new Function2<Boolean, ArgbMember, ArgbMember>(){

        @Override
        public Boolean call(ArgbMember a, ArgbMember b) {
            return a.a() == b.a() && a.r() == b.r() && a.b() == b.b() && a.g() == b.g();
        }
    };
    private final Function2<Boolean, ArgbMember, ArgbMember> NEQ = new Function2<Boolean, ArgbMember, ArgbMember>(){

        @Override
        public Boolean call(ArgbMember a, ArgbMember b) {
            return (Boolean)ArgbAlgebra.this.EQ.call(a, b) == false;
        }
    };
    private final Procedure2<ArgbMember, ArgbMember> AS = new Procedure2<ArgbMember, ArgbMember>(){

        @Override
        public void call(ArgbMember a, ArgbMember b) {
            b.set(a);
        }
    };
    private final Function1<Boolean, ArgbMember> ISZ = new Function1<Boolean, ArgbMember>(){

        @Override
        public Boolean call(ArgbMember a) {
            return a.a() == 0 && a.r() == 0 && a.g() == 0 && a.b() == 0;
        }
    };
    private final Procedure1<ArgbMember> RAND = new Procedure1<ArgbMember>(){

        @Override
        public void call(ArgbMember a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setA(0);
            a.setR(rng.nextInt(256));
            a.setG(rng.nextInt(256));
            a.setB(rng.nextInt(256));
        }
    };
    private final Procedure1<ArgbMember> MAXB = new Procedure1<ArgbMember>(){

        @Override
        public void call(ArgbMember a) {
            a.setA(255);
            a.setR(255);
            a.setG(255);
            a.setB(255);
        }
    };
    private final Procedure1<ArgbMember> MINB = new Procedure1<ArgbMember>(){

        @Override
        public void call(ArgbMember a) {
            a.setA(0);
            a.setR(0);
            a.setG(0);
            a.setB(0);
        }
    };
    private final Procedure1<ArgbMember> ZERO = new Procedure1<ArgbMember>(){

        @Override
        public void call(ArgbMember a) {
            a.setA(0);
            a.setR(0);
            a.setG(0);
            a.setB(0);
        }
    };
    private final Procedure4<Double, ArgbMember, ArgbMember, ArgbMember> BLEND = new Procedure4<Double, ArgbMember, ArgbMember, ArgbMember>(){

        @Override
        public void call(Double t, ArgbMember a, ArgbMember b, ArgbMember c) {
            c.setA(RgbUtils.blendAlpha(t, a.a(), b.a()));
            c.setR(RgbUtils.blendColor(t, a.r(), b.r()));
            c.setG(RgbUtils.blendColor(t, a.g(), b.g()));
            c.setB(RgbUtils.blendColor(t, a.b(), b.b()));
        }
    };

    @Override
    public ArgbMember construct() {
        return new ArgbMember();
    }

    @Override
    public ArgbMember construct(ArgbMember other) {
        return other.duplicate();
    }

    @Override
    public ArgbMember construct(String str) {
        throw new IllegalArgumentException("to be implemented");
    }

    @Override
    public Function2<Boolean, ArgbMember, ArgbMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ArgbMember, ArgbMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<ArgbMember, ArgbMember> assign() {
        return this.AS;
    }

    @Override
    public Function1<Boolean, ArgbMember> isZero() {
        return this.ISZ;
    }

    @Override
    public Procedure1<ArgbMember> random() {
        return this.RAND;
    }

    @Override
    public Procedure1<ArgbMember> maxBound() {
        return this.MAXB;
    }

    @Override
    public Procedure1<ArgbMember> minBound() {
        return this.MINB;
    }

    @Override
    public Procedure1<ArgbMember> zero() {
        return this.ZERO;
    }

    public Procedure4<Double, ArgbMember, ArgbMember, ArgbMember> blend() {
        return this.BLEND;
    }
}

