/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.rgb;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;

public class ArgbMember
implements ByteCoder,
Allocatable<ArgbMember>,
Duplicatable<ArgbMember>,
Settable<ArgbMember>,
Gettable<ArgbMember>,
NumberMember<ArgbMember> {
    private byte a;
    private byte r;
    private byte g;
    private byte b;

    public ArgbMember() {
    }

    public ArgbMember(int a, int r, int g, int b) {
        this.setA(a);
        this.setR(r);
        this.setG(g);
        this.setB(b);
    }

    public void setA(int a) {
        this.a = (byte)(a & 0xFF);
    }

    public void setR(int r) {
        this.r = (byte)(r & 0xFF);
    }

    public void setG(int g) {
        this.g = (byte)(g & 0xFF);
    }

    public void setB(int b) {
        this.b = (byte)(b & 0xFF);
    }

    public int a() {
        return this.a & 0xFF;
    }

    public int r() {
        return this.r & 0xFF;
    }

    public int g() {
        return this.g & 0xFF;
    }

    public int b() {
        return this.b & 0xFF;
    }

    @Override
    public int byteCount() {
        return 4;
    }

    @Override
    public void fromByteArray(byte[] arr, int index) {
        this.a = arr[index];
        this.r = arr[index + 1];
        this.g = arr[index + 2];
        this.b = arr[index + 3];
    }

    @Override
    public void toByteArray(byte[] arr, int index) {
        arr[index] = this.a;
        arr[index + 1] = this.r;
        arr[index + 2] = this.g;
        arr[index + 3] = this.b;
    }

    @Override
    public void fromByteFile(RandomAccessFile raf) throws IOException {
        this.a = raf.readByte();
        this.r = raf.readByte();
        this.g = raf.readByte();
        this.b = raf.readByte();
    }

    @Override
    public void toByteFile(RandomAccessFile raf) throws IOException {
        raf.writeByte(this.a);
        raf.writeByte(this.r);
        raf.writeByte(this.g);
        raf.writeByte(this.b);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative index");
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(ArgbMember value) {
        this.get(value);
    }

    @Override
    public void setV(ArgbMember value) {
        this.set(value);
    }

    @Override
    public void get(ArgbMember other) {
        other.a = this.a;
        other.r = this.r;
        other.g = this.g;
        other.b = this.b;
    }

    @Override
    public void set(ArgbMember other) {
        this.a = other.a;
        this.r = other.r;
        this.g = other.g;
        this.b = other.b;
    }

    @Override
    public ArgbMember duplicate() {
        ArgbMember val = this.allocate();
        this.get(val);
        return val;
    }

    @Override
    public ArgbMember allocate() {
        return new ArgbMember();
    }
}

