/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.rgb;

import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.data.rgb.RgbMember;
import nom.bdezonia.zorbage.type.data.rgb.RgbUtils;

public class RgbAlgebra
implements Algebra<RgbAlgebra, RgbMember>,
Bounded<RgbMember>,
Random<RgbMember> {
    private final Function2<Boolean, RgbMember, RgbMember> EQ = new Function2<Boolean, RgbMember, RgbMember>(){

        @Override
        public Boolean call(RgbMember a, RgbMember b) {
            return a.r() == b.r() && a.b() == b.b() && a.g() == b.g();
        }
    };
    private final Function2<Boolean, RgbMember, RgbMember> NEQ = new Function2<Boolean, RgbMember, RgbMember>(){

        @Override
        public Boolean call(RgbMember a, RgbMember b) {
            return (Boolean)RgbAlgebra.this.EQ.call(a, b) == false;
        }
    };
    private final Procedure2<RgbMember, RgbMember> AS = new Procedure2<RgbMember, RgbMember>(){

        @Override
        public void call(RgbMember a, RgbMember b) {
            b.set(a);
        }
    };
    private final Function1<Boolean, RgbMember> ISZ = new Function1<Boolean, RgbMember>(){

        @Override
        public Boolean call(RgbMember a) {
            return a.r() == 0 && a.g() == 0 && a.b() == 0;
        }
    };
    private final Procedure1<RgbMember> RAND = new Procedure1<RgbMember>(){

        @Override
        public void call(RgbMember a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextInt(256));
            a.setG(rng.nextInt(256));
            a.setB(rng.nextInt(256));
        }
    };
    private final Procedure1<RgbMember> MAXB = new Procedure1<RgbMember>(){

        @Override
        public void call(RgbMember a) {
            a.setR(255);
            a.setG(255);
            a.setB(255);
        }
    };
    private final Procedure1<RgbMember> MINB = new Procedure1<RgbMember>(){

        @Override
        public void call(RgbMember a) {
            a.setR(0);
            a.setG(0);
            a.setB(0);
        }
    };
    private final Procedure1<RgbMember> ZERO = new Procedure1<RgbMember>(){

        @Override
        public void call(RgbMember a) {
            a.setR(0);
            a.setG(0);
            a.setB(0);
        }
    };
    private final Procedure4<Double, RgbMember, RgbMember, RgbMember> BLEND = new Procedure4<Double, RgbMember, RgbMember, RgbMember>(){

        @Override
        public void call(Double t, RgbMember a, RgbMember b, RgbMember c) {
            c.setR(RgbUtils.blendColor(t, a.r(), b.r()));
            c.setG(RgbUtils.blendColor(t, a.g(), b.g()));
            c.setB(RgbUtils.blendColor(t, a.b(), b.b()));
        }
    };

    @Override
    public RgbMember construct() {
        return new RgbMember();
    }

    @Override
    public RgbMember construct(RgbMember other) {
        return other.duplicate();
    }

    @Override
    public RgbMember construct(String str) {
        throw new IllegalArgumentException("to be implemented");
    }

    @Override
    public Function2<Boolean, RgbMember, RgbMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, RgbMember, RgbMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<RgbMember, RgbMember> assign() {
        return this.AS;
    }

    @Override
    public Function1<Boolean, RgbMember> isZero() {
        return this.ISZ;
    }

    @Override
    public Procedure1<RgbMember> random() {
        return this.RAND;
    }

    @Override
    public Procedure1<RgbMember> maxBound() {
        return this.MAXB;
    }

    @Override
    public Procedure1<RgbMember> minBound() {
        return this.MINB;
    }

    @Override
    public Procedure1<RgbMember> zero() {
        return this.ZERO;
    }

    public Procedure4<Double, RgbMember, RgbMember, RgbMember> blend() {
        return this.BLEND;
    }
}

