/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.rgb;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;

public class RgbMember
implements ByteCoder,
Allocatable<RgbMember>,
Duplicatable<RgbMember>,
Settable<RgbMember>,
Gettable<RgbMember>,
NumberMember<RgbMember> {
    private byte r;
    private byte g;
    private byte b;

    public RgbMember() {
    }

    public RgbMember(int r, int g, int b) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
    }

    public void setR(int r) {
        this.r = (byte)(r & 0xFF);
    }

    public void setG(int g) {
        this.g = (byte)(g & 0xFF);
    }

    public void setB(int b) {
        this.b = (byte)(b & 0xFF);
    }

    public int r() {
        return this.r & 0xFF;
    }

    public int g() {
        return this.g & 0xFF;
    }

    public int b() {
        return this.b & 0xFF;
    }

    @Override
    public int byteCount() {
        return 3;
    }

    @Override
    public void fromByteArray(byte[] arr, int index) {
        this.r = arr[index];
        this.g = arr[index + 1];
        this.b = arr[index + 2];
    }

    @Override
    public void toByteArray(byte[] arr, int index) {
        arr[index] = this.r;
        arr[index + 1] = this.g;
        arr[index + 2] = this.b;
    }

    @Override
    public void fromByteFile(RandomAccessFile raf) throws IOException {
        this.r = raf.readByte();
        this.g = raf.readByte();
        this.b = raf.readByte();
    }

    @Override
    public void toByteFile(RandomAccessFile raf) throws IOException {
        raf.writeByte(this.r);
        raf.writeByte(this.g);
        raf.writeByte(this.b);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative index");
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(RgbMember value) {
        this.get(value);
    }

    @Override
    public void setV(RgbMember value) {
        this.set(value);
    }

    @Override
    public void get(RgbMember other) {
        other.r = this.r;
        other.g = this.g;
        other.b = this.b;
    }

    @Override
    public void set(RgbMember other) {
        this.r = other.r;
        this.g = other.g;
        this.b = other.b;
    }

    @Override
    public RgbMember duplicate() {
        RgbMember val = this.allocate();
        this.get(val);
        return val;
    }

    @Override
    public RgbMember allocate() {
        return new RgbMember();
    }
}

