/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.tuple;

import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.tuple.Tuple3;
import nom.bdezonia.zorbage.type.algebra.Algebra;

public class Tuple3Algebra<A extends Algebra<A, B>, B, C extends Algebra<C, D>, D, E extends Algebra<E, F>, F>
implements Algebra<Tuple3Algebra<A, B, C, D, E, F>, Tuple3<B, D, F>> {
    private final A alg1;
    private final C alg2;
    private final E alg3;
    private final Function2<Boolean, Tuple3<B, D, F>, Tuple3<B, D, F>> EQ = new Function2<Boolean, Tuple3<B, D, F>, Tuple3<B, D, F>>(){

        @Override
        public Boolean call(Tuple3<B, D, F> a, Tuple3<B, D, F> b) {
            return Tuple3Algebra.this.alg1.isEqual().call(a.a(), b.a()) != false && Tuple3Algebra.this.alg2.isEqual().call(a.b(), b.b()) != false && Tuple3Algebra.this.alg3.isEqual().call(a.c(), b.c()) != false;
        }
    };
    private final Function2<Boolean, Tuple3<B, D, F>, Tuple3<B, D, F>> NEQ = new Function2<Boolean, Tuple3<B, D, F>, Tuple3<B, D, F>>(){

        @Override
        public Boolean call(Tuple3<B, D, F> a, Tuple3<B, D, F> b) {
            return Tuple3Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Tuple3<B, D, F>, Tuple3<B, D, F>> ASSIGN = new Procedure2<Tuple3<B, D, F>, Tuple3<B, D, F>>(){

        @Override
        public void call(Tuple3<B, D, F> a, Tuple3<B, D, F> b) {
            Tuple3Algebra.this.alg1.assign().call(a.a(), b.a());
            Tuple3Algebra.this.alg2.assign().call(a.b(), b.b());
            Tuple3Algebra.this.alg3.assign().call(a.c(), b.c());
        }
    };
    private final Function1<Boolean, Tuple3<B, D, F>> ISZERO = new Function1<Boolean, Tuple3<B, D, F>>(){

        @Override
        public Boolean call(Tuple3<B, D, F> a) {
            return Tuple3Algebra.this.alg1.isZero().call(a.a()) != false && Tuple3Algebra.this.alg2.isZero().call(a.b()) != false && Tuple3Algebra.this.alg3.isZero().call(a.c()) != false;
        }
    };
    private final Procedure1<Tuple3<B, D, F>> ZERO = new Procedure1<Tuple3<B, D, F>>(){

        @Override
        public void call(Tuple3<B, D, F> a) {
            Tuple3Algebra.this.alg1.zero().call(a.a());
            Tuple3Algebra.this.alg2.zero().call(a.b());
            Tuple3Algebra.this.alg3.zero().call(a.c());
        }
    };

    public Tuple3Algebra(A alg1, C alg2, E alg3) {
        this.alg1 = alg1;
        this.alg2 = alg2;
        this.alg3 = alg3;
    }

    @Override
    public Tuple3<B, D, F> construct() {
        return new Tuple3(this.alg1.construct(), this.alg2.construct(), this.alg3.construct());
    }

    @Override
    public Tuple3<B, D, F> construct(Tuple3<B, D, F> other) {
        Object result = this.construct();
        this.assign().call((Tuple3<Object, D, F>)other, (Tuple3<Object, D, F>)result);
        return result;
    }

    @Override
    public Tuple3<B, D, F> construct(String str) {
        throw new IllegalArgumentException("to be implemented");
    }

    @Override
    public Function2<Boolean, Tuple3<B, D, F>, Tuple3<B, D, F>> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Tuple3<B, D, F>, Tuple3<B, D, F>> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<Tuple3<B, D, F>, Tuple3<B, D, F>> assign() {
        return this.ASSIGN;
    }

    @Override
    public Function1<Boolean, Tuple3<B, D, F>> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<Tuple3<B, D, F>> zero() {
        return this.ZERO;
    }
}

