/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.unbounded;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Integer;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;
import nom.bdezonia.zorbage.type.data.unbounded.UnboundedIntMember;

public class UnboundedIntAlgebra
implements Integer<UnboundedIntAlgebra, UnboundedIntMember>,
BitOperations<UnboundedIntMember>,
Tolerance<UnboundedIntMember, UnboundedIntMember> {
    private static final UnboundedIntMember ZERO = new UnboundedIntMember();
    private static final UnboundedIntMember ONE = new UnboundedIntMember(BigInteger.ONE);
    private final Procedure2<UnboundedIntMember, UnboundedIntMember> ABS = new Procedure2<UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().abs());
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> MUL = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().multiply(b.v()));
        }
    };
    private final Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> POWER = new Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(java.lang.Integer power, UnboundedIntMember a, UnboundedIntMember b) {
            if (power == 0 && a.v() == BigInteger.ZERO) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            if (power < 0) {
                throw new IllegalArgumentException("Cannot get negative powers from integers");
            }
            b.setV(a.v().pow(power));
        }
    };
    private final Procedure1<UnboundedIntMember> ZER = new Procedure1<UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<UnboundedIntMember, UnboundedIntMember> NEG = new Procedure2<UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().negate());
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> ADD = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().add(b.v()));
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> SUB = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().subtract(b.v()));
        }
    };
    private final Function2<Boolean, UnboundedIntMember, UnboundedIntMember> EQ = new Function2<Boolean, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a, UnboundedIntMember b) {
            return UnboundedIntAlgebra.this.compare().call(a, b) == 0;
        }
    };
    private final Function2<Boolean, UnboundedIntMember, UnboundedIntMember> NEQ = new Function2<Boolean, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a, UnboundedIntMember b) {
            return UnboundedIntAlgebra.this.compare().call(a, b) != 0;
        }
    };
    private final Procedure2<UnboundedIntMember, UnboundedIntMember> ASSIGN = new Procedure2<UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember from, UnboundedIntMember to) {
            to.set(from);
        }
    };
    private final Procedure1<UnboundedIntMember> UNI = new Procedure1<UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a) {
            a.setV(BigInteger.ONE);
        }
    };
    private final Function2<Boolean, UnboundedIntMember, UnboundedIntMember> LS = new Function2<Boolean, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a, UnboundedIntMember b) {
            return UnboundedIntAlgebra.this.compare().call(a, b) < 0;
        }
    };
    private final Function2<Boolean, UnboundedIntMember, UnboundedIntMember> LSE = new Function2<Boolean, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a, UnboundedIntMember b) {
            return UnboundedIntAlgebra.this.compare().call(a, b) <= 0;
        }
    };
    private final Function2<Boolean, UnboundedIntMember, UnboundedIntMember> GR = new Function2<Boolean, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a, UnboundedIntMember b) {
            return UnboundedIntAlgebra.this.compare().call(a, b) > 0;
        }
    };
    private final Function2<Boolean, UnboundedIntMember, UnboundedIntMember> GRE = new Function2<Boolean, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a, UnboundedIntMember b) {
            return UnboundedIntAlgebra.this.compare().call(a, b) >= 0;
        }
    };
    private final Function2<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> CMP = new Function2<java.lang.Integer, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public java.lang.Integer call(UnboundedIntMember a, UnboundedIntMember b) {
            return a.v().compareTo(b.v());
        }
    };
    private final Function1<java.lang.Integer, UnboundedIntMember> SIG = new Function1<java.lang.Integer, UnboundedIntMember>(){

        @Override
        public java.lang.Integer call(UnboundedIntMember a) {
            return a.v().signum();
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> DIV = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().divide(b.v()));
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> MOD = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().remainder(b.v()));
        }
    };
    private final Procedure4<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> DIVMOD = new Procedure4<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember d, UnboundedIntMember m) {
            BigInteger[] results = a.v().divideAndRemainder(b.v());
            d.setV(results[0]);
            m.setV(results[1]);
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> GCD = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().gcd(b.v()));
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> LCM = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            BigInteger n = a.v().multiply(b.v()).abs();
            BigInteger d = a.v().gcd(b.v());
            c.setV(n.divide(d));
        }
    };
    private final Function1<Boolean, UnboundedIntMember> EV = new Function1<Boolean, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a) {
            return UnboundedIntAlgebra.this.isOdd().call(a) == false;
        }
    };
    private final Function1<Boolean, UnboundedIntMember> OD = new Function1<Boolean, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a) {
            return a.v().and(BigInteger.ONE).equals(BigInteger.ONE);
        }
    };
    private final Procedure2<UnboundedIntMember, UnboundedIntMember> PRD = new Procedure2<UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b) {
            UnboundedIntAlgebra.this.subtract().call(a, ONE, b);
        }
    };
    private final Procedure2<UnboundedIntMember, UnboundedIntMember> SUC = new Procedure2<UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b) {
            UnboundedIntAlgebra.this.add().call(a, ONE, b);
        }
    };
    private final Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> SHL = new Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(java.lang.Integer count, UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().shiftLeft(count));
        }
    };
    private final Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> SHR = new Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(java.lang.Integer count, UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().shiftRight(count));
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> AND = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().and(b.v()));
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> OR = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().or(b.v()));
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> XOR = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().xor(b.v()));
        }
    };
    private final Procedure2<UnboundedIntMember, UnboundedIntMember> NOT = new Procedure2<UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().not());
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> BITANDNOT = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().and(b.v().not()));
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> MIN = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            Min.compute(G.UNBOUND, a, b, c);
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> MAX = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            Max.compute(G.UNBOUND, a, b, c);
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> ANDNOT = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().andNot(b.v()));
        }
    };
    private final Function1<java.lang.Integer, UnboundedIntMember> BC = new Function1<java.lang.Integer, UnboundedIntMember>(){

        @Override
        public java.lang.Integer call(UnboundedIntMember a) {
            return a.v().bitCount();
        }
    };
    private final Function1<java.lang.Integer, UnboundedIntMember> BL = new Function1<java.lang.Integer, UnboundedIntMember>(){

        @Override
        public java.lang.Integer call(UnboundedIntMember a) {
            return a.v().bitLength();
        }
    };
    private final Function1<java.lang.Integer, UnboundedIntMember> LSB = new Function1<java.lang.Integer, UnboundedIntMember>(){

        @Override
        public java.lang.Integer call(UnboundedIntMember a) {
            return a.v().getLowestSetBit();
        }
    };
    private final Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> CB = new Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(java.lang.Integer n, UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().clearBit(n));
        }
    };
    private final Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> FB = new Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(java.lang.Integer n, UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().flipBit(n));
        }
    };
    private final Function2<Boolean, java.lang.Integer, UnboundedIntMember> IPP = new Function2<Boolean, java.lang.Integer, UnboundedIntMember>(){

        @Override
        public Boolean call(java.lang.Integer certainty, UnboundedIntMember a) {
            return a.v().isProbablePrime(certainty);
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> MI = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            c.setV(a.v().modInverse(b.v()));
        }
    };
    private final Procedure4<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> MP = new Procedure4<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c, UnboundedIntMember d) {
            d.setV(a.v().modPow(b.v(), c.v()));
        }
    };
    private final Procedure2<UnboundedIntMember, UnboundedIntMember> NPP = new Procedure2<UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().nextProbablePrime());
        }
    };
    private final Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> SB = new Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(java.lang.Integer n, UnboundedIntMember a, UnboundedIntMember b) {
            b.setV(a.v().setBit(n));
        }
    };
    private final Function2<Boolean, java.lang.Integer, UnboundedIntMember> TB = new Function2<Boolean, java.lang.Integer, UnboundedIntMember>(){

        @Override
        public Boolean call(java.lang.Integer n, UnboundedIntMember a) {
            return a.v().testBit(n);
        }
    };
    private final Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> POW = new Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(UnboundedIntMember a, UnboundedIntMember b, UnboundedIntMember c) {
            int cmp = b.v().compareTo(BigInteger.ZERO);
            if (cmp < 0) {
                throw new IllegalArgumentException("negative powers not supported for unbounded ints");
            }
            if (cmp == 0) {
                if (a.v() == BigInteger.ZERO) {
                    throw new IllegalArgumentException("0^0 is not a number");
                }
                UnboundedIntAlgebra.this.assign().call(ONE, c);
            } else if (b.v().compareTo(BigInteger.valueOf(java.lang.Integer.MAX_VALUE)) <= 0) {
                c.setV(a.v().pow(b.v().intValue()));
            } else {
                UnboundedIntMember tmp = new UnboundedIntMember(ONE);
                UnboundedIntMember power = new UnboundedIntMember(b);
                while (UnboundedIntAlgebra.this.isGreater().call(power, ZERO).booleanValue()) {
                    UnboundedIntAlgebra.this.multiply().call(tmp, a, tmp);
                    UnboundedIntAlgebra.this.pred().call(power, power);
                }
                UnboundedIntAlgebra.this.assign().call(tmp, c);
            }
        }
    };
    private final Function1<Boolean, UnboundedIntMember> ISZERO = new Function1<Boolean, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember a) {
            return a.v() == BigInteger.ZERO;
        }
    };
    private final Procedure3<HighPrecisionMember, UnboundedIntMember, UnboundedIntMember> SBHP = new Procedure3<HighPrecisionMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(HighPrecisionMember a, UnboundedIntMember b, UnboundedIntMember c) {
            BigDecimal tmp = a.v();
            tmp = tmp.multiply(new BigDecimal(b.v()));
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<HighPrecisionMember, UnboundedIntMember, UnboundedIntMember> SBHPR = new Procedure3<HighPrecisionMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(HighPrecisionMember a, UnboundedIntMember b, UnboundedIntMember c) {
            BigDecimal tmp = a.v();
            int signum = (tmp = tmp.multiply(new BigDecimal(b.v()))).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<RationalMember, UnboundedIntMember, UnboundedIntMember> SBR = new Procedure3<RationalMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(RationalMember a, UnboundedIntMember b, UnboundedIntMember c) {
            BigInteger tmp = b.v();
            tmp = tmp.multiply(a.n());
            tmp = tmp.divide(a.d());
            c.setV(tmp);
        }
    };
    private final Procedure3<Double, UnboundedIntMember, UnboundedIntMember> SBD = new Procedure3<Double, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(Double a, UnboundedIntMember b, UnboundedIntMember c) {
            BigDecimal tmp = new BigDecimal(b.v());
            BigDecimal d = BigDecimal.valueOf(a);
            tmp = tmp.multiply(d);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Procedure3<Double, UnboundedIntMember, UnboundedIntMember> SBDR = new Procedure3<Double, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public void call(Double a, UnboundedIntMember b, UnboundedIntMember c) {
            BigDecimal tmp = new BigDecimal(b.v());
            BigDecimal d = BigDecimal.valueOf(a);
            int signum = (tmp = tmp.multiply(d)).signum();
            tmp = signum < 0 ? tmp.subtract(G.ONE_HALF) : tmp.add(G.ONE_HALF);
            c.setV(tmp.toBigInteger());
        }
    };
    private final Function3<Boolean, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> WITHIN = new Function3<Boolean, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember>(){

        @Override
        public Boolean call(UnboundedIntMember tol, UnboundedIntMember a, UnboundedIntMember b) {
            return NumberWithin.compute(G.UNBOUND, tol, a, b);
        }
    };

    @Override
    public Procedure2<UnboundedIntMember, UnboundedIntMember> abs() {
        return this.ABS;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<UnboundedIntMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<UnboundedIntMember, UnboundedIntMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, UnboundedIntMember, UnboundedIntMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, UnboundedIntMember, UnboundedIntMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public UnboundedIntMember construct() {
        return new UnboundedIntMember();
    }

    @Override
    public UnboundedIntMember construct(UnboundedIntMember other) {
        return new UnboundedIntMember(other);
    }

    @Override
    public UnboundedIntMember construct(String s) {
        return new UnboundedIntMember(s);
    }

    @Override
    public Procedure2<UnboundedIntMember, UnboundedIntMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<UnboundedIntMember> unity() {
        return this.UNI;
    }

    @Override
    public Function2<Boolean, UnboundedIntMember, UnboundedIntMember> isLess() {
        return this.LS;
    }

    @Override
    public Function2<Boolean, UnboundedIntMember, UnboundedIntMember> isLessEqual() {
        return this.LSE;
    }

    @Override
    public Function2<Boolean, UnboundedIntMember, UnboundedIntMember> isGreater() {
        return this.GR;
    }

    @Override
    public Function2<Boolean, UnboundedIntMember, UnboundedIntMember> isGreaterEqual() {
        return this.GRE;
    }

    @Override
    public Function2<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> compare() {
        return this.CMP;
    }

    @Override
    public Function1<java.lang.Integer, UnboundedIntMember> signum() {
        return this.SIG;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> gcd() {
        return this.GCD;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> lcm() {
        return this.LCM;
    }

    @Override
    public Procedure2<UnboundedIntMember, UnboundedIntMember> norm() {
        return this.ABS;
    }

    @Override
    public Function1<Boolean, UnboundedIntMember> isEven() {
        return this.EV;
    }

    @Override
    public Function1<Boolean, UnboundedIntMember> isOdd() {
        return this.OD;
    }

    @Override
    public Procedure2<UnboundedIntMember, UnboundedIntMember> pred() {
        return this.PRD;
    }

    @Override
    public Procedure2<UnboundedIntMember, UnboundedIntMember> succ() {
        return this.SUC;
    }

    @Override
    public Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> bitShiftLeft() {
        return this.SHL;
    }

    @Override
    public Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> bitShiftRight() {
        return this.SHR;
    }

    @Override
    public Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> bitShiftRightFillZero() {
        return this.SHR;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> bitAnd() {
        return this.AND;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> bitOr() {
        return this.OR;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> bitXor() {
        return this.XOR;
    }

    @Override
    public Procedure2<UnboundedIntMember, UnboundedIntMember> bitNot() {
        return this.NOT;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> bitAndNot() {
        return this.BITANDNOT;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> max() {
        return this.MAX;
    }

    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> andNot() {
        return this.ANDNOT;
    }

    public Function1<java.lang.Integer, UnboundedIntMember> bitCount() {
        return this.BC;
    }

    public Function1<java.lang.Integer, UnboundedIntMember> bitLength() {
        return this.BL;
    }

    public Function1<java.lang.Integer, UnboundedIntMember> getLowestSetBit() {
        return this.LSB;
    }

    public Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> clearBit() {
        return this.CB;
    }

    public Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> flipBit() {
        return this.FB;
    }

    public Function2<Boolean, java.lang.Integer, UnboundedIntMember> isProbablePrime() {
        return this.IPP;
    }

    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> modInverse() {
        return this.MI;
    }

    public Procedure4<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> modPow() {
        return this.MP;
    }

    public Procedure2<UnboundedIntMember, UnboundedIntMember> nextProbablePrime() {
        return this.NPP;
    }

    public Procedure3<java.lang.Integer, UnboundedIntMember, UnboundedIntMember> setBit() {
        return this.SB;
    }

    public Function2<Boolean, java.lang.Integer, UnboundedIntMember> testBit() {
        return this.TB;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> pow() {
        return this.POW;
    }

    @Override
    public Function1<Boolean, UnboundedIntMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnboundedIntMember, UnboundedIntMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<HighPrecisionMember, UnboundedIntMember, UnboundedIntMember> scaleByHighPrecAndRound() {
        return this.SBHPR;
    }

    @Override
    public Procedure3<RationalMember, UnboundedIntMember, UnboundedIntMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, UnboundedIntMember, UnboundedIntMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Double, UnboundedIntMember, UnboundedIntMember> scaleByDoubleAndRound() {
        return this.SBDR;
    }

    @Override
    public Function3<Boolean, UnboundedIntMember, UnboundedIntMember, UnboundedIntMember> within() {
        return this.WITHIN;
    }
}

