/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.universal;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;

public class FindCompatibleType {
    public static PrimitiveRepresentation bestRep(PrimitiveConversion a, PrimitiveConversion b) {
        if (a.preferredRepresentation() == PrimitiveRepresentation.BIGDECIMAL || b.preferredRepresentation() == PrimitiveRepresentation.BIGDECIMAL) {
            return PrimitiveRepresentation.BIGDECIMAL;
        }
        if (a.preferredRepresentation() == PrimitiveRepresentation.DOUBLE || b.preferredRepresentation() == PrimitiveRepresentation.DOUBLE) {
            return PrimitiveRepresentation.DOUBLE;
        }
        if (a.preferredRepresentation() == PrimitiveRepresentation.FLOAT || b.preferredRepresentation() == PrimitiveRepresentation.FLOAT) {
            return PrimitiveRepresentation.FLOAT;
        }
        if (a.preferredRepresentation() == PrimitiveRepresentation.BIGINTEGER || b.preferredRepresentation() == PrimitiveRepresentation.BIGINTEGER) {
            return PrimitiveRepresentation.BIGINTEGER;
        }
        if (a.preferredRepresentation() == PrimitiveRepresentation.LONG || b.preferredRepresentation() == PrimitiveRepresentation.LONG) {
            return PrimitiveRepresentation.LONG;
        }
        if (a.preferredRepresentation() == PrimitiveRepresentation.INT || b.preferredRepresentation() == PrimitiveRepresentation.INT) {
            return PrimitiveRepresentation.INT;
        }
        if (a.preferredRepresentation() == PrimitiveRepresentation.SHORT || b.preferredRepresentation() == PrimitiveRepresentation.SHORT) {
            return PrimitiveRepresentation.SHORT;
        }
        if (a.preferredRepresentation() == PrimitiveRepresentation.BYTE || b.preferredRepresentation() == PrimitiveRepresentation.BYTE) {
            return PrimitiveRepresentation.BYTE;
        }
        throw new IllegalArgumentException("unknown representations " + (Object)((Object)a.preferredRepresentation()) + " " + (Object)((Object)b.preferredRepresentation()));
    }

    public static <T> T bestAlgebra(int components, PrimitiveRepresentation rep) {
        if (components <= 0) {
            throw new IllegalArgumentException("must specify 1 or more components");
        }
        if (components > 8) {
            throw new IllegalArgumentException("must specify 8 or fewer components");
        }
        switch (rep) {
            case BIGDECIMAL: {
                if (components == 1) {
                    return (T)G.HP;
                }
                if (components == 2) {
                    return (T)G.CHP;
                }
                if (components == 4) {
                    return (T)G.QHP;
                }
                if (components != 8) break;
                return (T)G.OHP;
            }
            case BIGINTEGER: {
                if (components != 1) break;
                return (T)G.UNBOUND;
            }
            case DOUBLE: {
                if (components == 1) {
                    return (T)G.DBL;
                }
                if (components <= 2) {
                    return (T)G.CDBL;
                }
                if (components <= 4) {
                    return (T)G.QDBL;
                }
                if (components > 8) break;
                return (T)G.ODBL;
            }
            case FLOAT: {
                if (components == 1) {
                    return (T)G.FLT;
                }
                if (components <= 2) {
                    return (T)G.CFLT;
                }
                if (components <= 4) {
                    return (T)G.QFLT;
                }
                if (components > 8) break;
                return (T)G.OFLT;
            }
            case LONG: {
                if (components != 1) break;
                return (T)G.INT64;
            }
            case INT: {
                if (components != 1) break;
                return (T)G.INT32;
            }
            case SHORT: {
                if (components != 1) break;
                return (T)G.INT16;
            }
            case BYTE: {
                if (components != 1) break;
                return (T)G.INT8;
            }
            default: {
                throw new IllegalArgumentException("unknown primitive rep " + (Object)((Object)rep));
            }
        }
        throw new IllegalArgumentException("can't find appropriate type");
    }
}

