/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.universal;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;

public class PrimitiveConverter {
    private PrimitiveConverter() {
    }

    public static void convert(PrimitiveConversion from, PrimitiveConversion to) {
        IntegerIndex tmp1 = new IntegerIndex(Math.max(from.numDimensions(), to.numDimensions()));
        IntegerIndex tmp2 = new IntegerIndex(tmp1.numDimensions());
        IntegerIndex tmp3 = new IntegerIndex(tmp1.numDimensions());
        PrimitiveConverter.convert(tmp1, tmp2, tmp3, from, to);
    }

    public static void convert(IntegerIndex tmp1, IntegerIndex tmp2, IntegerIndex tmp3, PrimitiveConversion from, PrimitiveConversion to) {
        int numD = Math.max(from.numDimensions(), to.numDimensions());
        if (tmp1.numDimensions() != numD) {
            throw new IllegalArgumentException("invalid tmp1 space");
        }
        if (tmp2.numDimensions() != numD) {
            throw new IllegalArgumentException("invalid tmp2 space");
        }
        if (tmp3.numDimensions() != numD) {
            throw new IllegalArgumentException("invalid tmp3 space");
        }
        if (numD == 0) {
            PrimitiveConverter.convertOneValue(tmp1, from, to);
        } else {
            int i;
            IntegerIndex min = tmp1;
            IntegerIndex max = tmp2;
            IntegerIndex tmp = tmp3;
            int minD = Math.min(from.numDimensions(), to.numDimensions());
            for (i = 0; i < minD; ++i) {
                min.set(i, 0L);
                max.set(i, Math.min(from.dimension(i), to.dimension(i)) - 1L);
            }
            for (i = minD; i < numD; ++i) {
                min.set(i, 0L);
                max.set(i, 0L);
            }
            to.primitiveInit();
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(min, max);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            while (iter.hasNext()) {
                iter.next(tmp);
                PrimitiveConverter.convertOneValue(tmp, from, to);
            }
        }
    }

    private static void convertOneValue(IntegerIndex index, PrimitiveConversion from, PrimitiveConversion to) {
        switch (from.preferredRepresentation()) {
            case BYTE: {
                for (int j = 0; j < to.componentCount(); ++j) {
                    byte v = from.primComponentGetAsByte(index, j);
                    to.primComponentSetByte(index, j, v);
                }
                break;
            }
            case SHORT: {
                for (int j = 0; j < to.componentCount(); ++j) {
                    short v = from.primComponentGetAsShort(index, j);
                    to.primComponentSetShort(index, j, v);
                }
                break;
            }
            case INT: {
                for (int j = 0; j < to.componentCount(); ++j) {
                    int v = from.primComponentGetAsInt(index, j);
                    to.primComponentSetInt(index, j, v);
                }
                break;
            }
            case LONG: {
                for (int j = 0; j < to.componentCount(); ++j) {
                    long v = from.primComponentGetAsLong(index, j);
                    to.primComponentSetLong(index, j, v);
                }
                break;
            }
            case FLOAT: {
                for (int j = 0; j < to.componentCount(); ++j) {
                    float v = from.primComponentGetAsFloat(index, j);
                    to.primComponentSetFloat(index, j, v);
                }
                break;
            }
            case DOUBLE: {
                for (int j = 0; j < to.componentCount(); ++j) {
                    double v = from.primComponentGetAsDouble(index, j);
                    to.primComponentSetDouble(index, j, v);
                }
                break;
            }
            case BIGINTEGER: {
                for (int j = 0; j < to.componentCount(); ++j) {
                    BigInteger v = from.primComponentGetAsBigInteger(index, j);
                    to.primComponentSetBigInteger(index, j, v);
                }
                break;
            }
            case BIGDECIMAL: {
                for (int j = 0; j < to.componentCount(); ++j) {
                    BigDecimal v = from.primComponentGetAsBigDecimal(index, j);
                    to.primComponentSetBigDecimal(index, j, v);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown primitive transfer type");
            }
        }
    }
}

