/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.universal;

import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.misc.LongUtils;
import nom.bdezonia.zorbage.type.algebra.DimensionsResizable;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;

public class TensorOctonionRepresentation
implements DimensionsResizable {
    private BigList<OctonionRepresentation> values;
    private long[] dims;

    public TensorOctonionRepresentation() {
        this.setDims(new long[0]);
    }

    @Override
    public void setDims(long[] dims) {
        long count = LongUtils.numElements(dims);
        if (count == 0L) {
            count = 1L;
        }
        if (this.values == null || count != this.values.size()) {
            this.values = new BigList(count);
            for (long i = 0L; i < count; ++i) {
                this.values.add(null);
            }
        }
        this.dims = (long[])dims.clone();
    }

    public long[] getDims() {
        return this.dims;
    }

    public boolean isValue() {
        return this.dims.length == 0;
    }

    public boolean isRModule() {
        return this.dims.length == 1;
    }

    public boolean isMatrix() {
        return this.dims.length == 2;
    }

    public boolean isTensor() {
        return this.dims.length > 2;
    }

    public void setValue(OctonionRepresentation value) {
        this.setDims(new long[0]);
        this.values.set(0L, value);
    }

    public void setRModule(long n, BigList<OctonionRepresentation> values) {
        this.setDims(new long[]{n});
        long thisValsSize = this.values.size();
        if (thisValsSize != values.size()) {
            throw new IllegalArgumentException("Incorrect number of values passed");
        }
        for (long i = 0L; i < thisValsSize; ++i) {
            this.values.set(i, values.get(i));
        }
    }

    public void setMatrix(long r, long c, BigList<OctonionRepresentation> values) {
        this.setDims(new long[]{c, r});
        long thisValsSize = this.values.size();
        if (thisValsSize != values.size()) {
            throw new IllegalArgumentException("Incorrect number of values passed");
        }
        for (long i = 0L; i < thisValsSize; ++i) {
            this.values.set(i, values.get(i));
        }
    }

    public void setTensor(long[] dims, BigList<OctonionRepresentation> values) {
        this.setDims(dims);
        long thisValsSize = this.values.size();
        if (thisValsSize != values.size()) {
            throw new IllegalArgumentException("Incorrect number of values passed");
        }
        for (long i = 0L; i < thisValsSize; ++i) {
            this.values.set(i, values.get(i));
        }
    }

    public OctonionRepresentation getValue() {
        return this.nonNull(this.values.get(0L));
    }

    public long getRModuleDim() {
        long size = 1L;
        if (this.dims.length >= 1 && this.dims[0] > 0L) {
            size = this.dims[0];
        }
        return size;
    }

    public BigList<OctonionRepresentation> getRModule() {
        long size = this.getRModuleDim();
        BigList<OctonionRepresentation> list = new BigList<OctonionRepresentation>(size);
        for (long i = 0L; i < size; ++i) {
            list.set(i, this.nonNull(this.values.get(i)));
        }
        return list;
    }

    public long getMatrixColDim() {
        long size = 1L;
        if (this.dims.length >= 1 && this.dims[0] > 0L) {
            size = this.dims[0];
        }
        return size;
    }

    public long getMatrixRowDim() {
        long size = 1L;
        if (this.dims.length >= 2 && this.dims[1] > 0L) {
            size = this.dims[1];
        }
        return size;
    }

    public BigList<OctonionRepresentation> getMatrix() {
        long r = this.getMatrixRowDim();
        long c = this.getMatrixColDim();
        long size = LongUtils.numElements(new long[]{c, r});
        BigList<OctonionRepresentation> list = new BigList<OctonionRepresentation>(size);
        for (long i = 0L; i < size; ++i) {
            list.set(i, this.nonNull(this.values.get(i)));
        }
        return list;
    }

    public long[] getTensorDims() {
        return (long[])this.dims.clone();
    }

    public BigList<OctonionRepresentation> getTensor() {
        long valuesSize = this.values.size();
        BigList<OctonionRepresentation> list = new BigList<OctonionRepresentation>(valuesSize);
        for (long i = 0L; i < valuesSize; ++i) {
            list.set(i, this.nonNull(this.values.get(i)));
        }
        return list;
    }

    private OctonionRepresentation nonNull(OctonionRepresentation o) {
        if (o != null) {
            return o;
        }
        return new OctonionRepresentation();
    }
}

