/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.universal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.misc.LongUtils;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;

public class TensorStringRepresentation {
    private long[] dimensions;
    private BigList<OctonionRepresentation> elements;
    private BigDecimal tmp;

    public TensorStringRepresentation(String s) {
        List<Character> chars = this.preprocessCharacters(s);
        this.dimensions = this.determineDimensions(chars);
        this.elements = new BigList();
        this.gatherOctonions(chars);
        if (this.elements.size() != LongUtils.numElements(this.dimensions)) {
            System.out.println("Parsed " + this.elements.size() + " values");
            System.out.println("Dims " + Arrays.toString(this.dimensions));
            throw new IllegalArgumentException("numbers parsed does not match dimensions of input tensor");
        }
    }

    public long[] dimensions() {
        return this.dimensions;
    }

    public OctonionRepresentation value(long[] index) {
        long idx = 0L;
        long increment = 1L;
        for (int i = 0; i < index.length; ++i) {
            idx += index[i] * increment;
            increment *= this.dimensions[i];
        }
        return this.elements.get(idx);
    }

    public BigList<OctonionRepresentation> values() {
        return this.elements;
    }

    public OctonionRepresentation firstValue() {
        return this.elements.get(0L);
    }

    public long firstVectorDimension() {
        long dim = 1L;
        if (this.dimensions.length >= 0) {
            dim = this.dimensions[0];
        }
        return dim;
    }

    public BigList<OctonionRepresentation> firstVectorValues() {
        long count = this.firstVectorDimension();
        BigList<OctonionRepresentation> vectorElements = new BigList<OctonionRepresentation>(count);
        for (long i = 0L; i < count; ++i) {
            vectorElements.set(i, this.elements.get(i));
        }
        return vectorElements;
    }

    public long[] firstMatrixDimensions() {
        long[] dims = new long[]{1L, 1L};
        if (this.dimensions.length >= 0) {
            dims[0] = this.dimensions[0];
        }
        if (this.dimensions.length >= 1) {
            dims[1] = this.dimensions[1];
        }
        return dims;
    }

    public BigList<OctonionRepresentation> firstMatrixValues() {
        long[] dims = this.firstMatrixDimensions();
        long count = dims[0] * dims[1];
        BigList<OctonionRepresentation> matrixElements = new BigList<OctonionRepresentation>(count);
        for (long i = 0L; i < count; ++i) {
            matrixElements.set(i, this.elements.get(i));
        }
        return matrixElements;
    }

    private List<Character> preprocessCharacters(String s) {
        ArrayList<Character> chars = new ArrayList<Character>();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            chars.add(Character.valueOf(c));
        }
        return chars;
    }

    private long[] determineDimensions(List<Character> chars) {
        int i;
        ArrayList<Long> reverseDims = new ArrayList<Long>();
        int unmatchedBrackets = 0;
        long innermostDim = 1L;
        boolean inOct = false;
        for (i = 0; i < chars.size(); ++i) {
            char ch = chars.get(i).charValue();
            if (ch == '[') {
                innermostDim = 1L;
                if (unmatchedBrackets < reverseDims.size()) {
                    reverseDims.set(unmatchedBrackets, (Long)reverseDims.get(unmatchedBrackets) + 1L);
                } else {
                    reverseDims.add(1L);
                }
                ++unmatchedBrackets;
                continue;
            }
            if (ch == ']') {
                if (--unmatchedBrackets >= 0) continue;
                throw new IllegalArgumentException("unexpected ] bracket in number parsing at index " + i + " of string " + Arrays.toString(chars.toArray()));
            }
            if (ch == '{') {
                inOct = true;
                continue;
            }
            if (ch == '}') {
                inOct = false;
                continue;
            }
            if (ch != ',' || inOct) continue;
            ++innermostDim;
        }
        if (unmatchedBrackets != 0) {
            throw new IllegalArgumentException("unmatched [ ] brackets in tensor definition");
        }
        for (i = reverseDims.size() - 1; i > 1; --i) {
            long sz = (Long)reverseDims.get(i - 1);
            reverseDims.set(i, (Long)reverseDims.get(i) / sz);
        }
        reverseDims.add(innermostDim);
        long[] dims = new long[reverseDims.size()];
        int x = 0;
        for (int i2 = reverseDims.size() - 1; i2 >= 0; --i2) {
            dims[x++] = (Long)reverseDims.get(i2);
        }
        if (dims.length > 1 && dims[dims.length - 1] == 1L) {
            long[] tmp = new long[dims.length - 1];
            for (int i3 = 0; i3 < tmp.length; ++i3) {
                tmp[i3] = dims[i3];
            }
            dims = tmp;
        }
        return dims;
    }

    private int findNextNumber(List<Character> chars, int ptr) {
        while (true) {
            if (ptr >= chars.size()) {
                return chars.size();
            }
            char ch = chars.get(ptr).charValue();
            if (ch != '[' && ch != ']' && ch != ',') break;
            ++ptr;
        }
        return ptr;
    }

    private void gatherOctonions(List<Character> chars) {
        int ptr = 0;
        while (ptr < chars.size()) {
            if ((ptr = this.findNextNumber(chars, ptr)) >= chars.size()) continue;
            ptr = this.octonion(chars, ptr);
        }
    }

    private int octonion(List<Character> input, int ptr) {
        BigDecimal[] vals = new BigDecimal[8];
        if (input.get(ptr).charValue() == '{') {
            int count = 0;
            while (ptr + 1 < input.size() && input.get(ptr + 1).charValue() != '}' && input.get(ptr + 1).charValue() != ',' && input.get(ptr + 1).charValue() != ']') {
                ptr = this.number(input, ptr + 1);
                if (count >= 8) continue;
                vals[count++] = this.tmp;
            }
            ++ptr;
        } else {
            ptr = this.number(input, ptr);
            vals[0] = this.tmp;
        }
        this.elements.add(new OctonionRepresentation(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5], vals[6], vals[7]));
        return ptr;
    }

    private int number(List<Character> input, int ptr) {
        StringBuilder buff = new StringBuilder();
        while (ptr != input.size()) {
            char ch;
            if ((ch = input.get(ptr++).charValue()) == '}' || ch == ',' || ch == ']') {
                --ptr;
                break;
            }
            buff.append(ch);
        }
        this.tmp = new BigDecimal(buff.toString());
        return ptr;
    }
}

