/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage;

import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class LinearAccessor<U> {
    private final U value;
    private final IndexedDataSource<U> storage;
    private long pos;
    private final long size;

    public LinearAccessor(U value, IndexedDataSource<U> storage) {
        this.value = value;
        this.storage = storage;
        this.size = storage.size();
        this.beforeFirst();
    }

    public void get() {
        this.storage.get(this.pos, this.value);
    }

    public void put() {
        this.storage.set(this.pos, this.value);
    }

    public boolean hasNext() {
        return this.pos + 1L >= 0L && this.pos + 1L < this.size;
    }

    public boolean hasPrev() {
        return this.pos - 1L >= 0L && this.pos - 1L < this.size;
    }

    public boolean hasNext(long steps) {
        return this.pos + steps >= 0L && this.pos + steps < this.size;
    }

    public boolean hasPrev(long steps) {
        return this.pos - steps >= 0L && this.pos - steps < this.size;
    }

    public void fwd() {
        ++this.pos;
    }

    public void back() {
        --this.pos;
    }

    public void fwd(long steps) {
        this.pos += steps;
    }

    public void back(long steps) {
        this.pos -= steps;
    }

    public void afterLast() {
        this.pos = this.size;
    }

    public void beforeFirst() {
        this.pos = -1L;
    }

    public long pos() {
        return this.pos;
    }
}

