/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.FileStorage;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorage;

public class Storage {
    public static <U extends Allocatable<U>> IndexedDataSource<U> allocate(long numElements, U type) {
        try {
            return ArrayStorage.allocate(numElements, type);
        }
        catch (OutOfMemoryError e) {
            return FileStorage.allocate(numElements, type);
        }
        catch (IllegalArgumentException e) {
            return FileStorage.allocate(numElements, type);
        }
    }

    public static <U extends Allocatable<U>> IndexedDataSource<U> allocate(StorageConstruction strategy, long numElements, U type) {
        if (strategy == StorageConstruction.MEM_ARRAY) {
            return ArrayStorage.allocate(numElements, type);
        }
        if (strategy == StorageConstruction.MEM_SPARSE) {
            return SparseStorage.allocate(numElements, type);
        }
        if (strategy == StorageConstruction.MEM_VIRTUAL) {
            return FileStorage.allocate(numElements, type);
        }
        throw new IllegalArgumentException("Unknown storage strategy " + (Object)((Object)strategy));
    }
}

