/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.data.bool.BooleanMember;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.int16.SignedInt16Member;
import nom.bdezonia.zorbage.type.data.int32.SignedInt32Member;
import nom.bdezonia.zorbage.type.data.int64.SignedInt64Member;
import nom.bdezonia.zorbage.type.data.int8.SignedInt8Member;
import nom.bdezonia.zorbage.type.data.unbounded.UnboundedIntMember;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageBigDecimal;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageBigInteger;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageBit;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageBoolean;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageFloat32;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageFloat64;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageSignedInt16;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageSignedInt32;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageSignedInt64;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageSignedInt8;
import nom.bdezonia.zorbage.type.storage.coder.BigDecimalCoder;
import nom.bdezonia.zorbage.type.storage.coder.BigIntegerCoder;
import nom.bdezonia.zorbage.type.storage.coder.BitCoder;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;
import nom.bdezonia.zorbage.type.storage.coder.FloatCoder;
import nom.bdezonia.zorbage.type.storage.coder.IntCoder;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorage {
    public static <U extends Allocatable<U>> IndexedDataSource<U> allocate(long size, U type) {
        if (type instanceof DoubleCoder) {
            return new ArrayStorageFloat64<DoubleCoder>(size, (DoubleCoder)((Object)type));
        }
        if (type instanceof FloatCoder) {
            return new ArrayStorageFloat32<FloatCoder>(size, (FloatCoder)((Object)type));
        }
        if (type instanceof LongCoder) {
            return new ArrayStorageSignedInt64<LongCoder>(size, (LongCoder)((Object)type));
        }
        if (type instanceof IntCoder) {
            return new ArrayStorageSignedInt32<IntCoder>(size, (IntCoder)((Object)type));
        }
        if (type instanceof ShortCoder) {
            return new ArrayStorageSignedInt16<ShortCoder>(size, (ShortCoder)((Object)type));
        }
        if (type instanceof BooleanCoder) {
            return new ArrayStorageBoolean<BooleanCoder>(size, (BooleanCoder)((Object)type));
        }
        if (type instanceof BigIntegerCoder) {
            return new ArrayStorageBigInteger<BigIntegerCoder>(size, (BigIntegerCoder)((Object)type));
        }
        if (type instanceof BigDecimalCoder) {
            return new ArrayStorageBigDecimal<BigDecimalCoder>(size, (BigDecimalCoder)((Object)type));
        }
        if (type instanceof ByteCoder) {
            return new ArrayStorageSignedInt8<ByteCoder>(size, (ByteCoder)((Object)type));
        }
        if (type instanceof BitCoder) {
            return new ArrayStorageBit<BitCoder>(size, (BitCoder)((Object)type));
        }
        throw new IllegalArgumentException("Unsupported type in ArrayStorage");
    }

    public static IndexedDataSource<SignedInt8Member> allocateBytes(byte[] bytes) {
        SignedInt8Member type = new SignedInt8Member();
        ArrayStorageSignedInt8<SignedInt8Member> store = new ArrayStorageSignedInt8<SignedInt8Member>(bytes.length, type);
        for (int i = 0; i < bytes.length; ++i) {
            type.setV(bytes[i]);
            store.set((long)i, type);
        }
        return store;
    }

    public static IndexedDataSource<SignedInt16Member> allocateShorts(short[] shorts) {
        SignedInt16Member type = new SignedInt16Member();
        ArrayStorageSignedInt16<SignedInt16Member> store = new ArrayStorageSignedInt16<SignedInt16Member>(shorts.length, type);
        for (int i = 0; i < shorts.length; ++i) {
            type.setV(shorts[i]);
            store.set((long)i, type);
        }
        return store;
    }

    public static IndexedDataSource<SignedInt32Member> allocateInts(int[] ints) {
        SignedInt32Member type = new SignedInt32Member();
        ArrayStorageSignedInt32<SignedInt32Member> store = new ArrayStorageSignedInt32<SignedInt32Member>(ints.length, type);
        for (int i = 0; i < ints.length; ++i) {
            type.setV(ints[i]);
            store.set((long)i, type);
        }
        return store;
    }

    public static IndexedDataSource<SignedInt64Member> allocateLongs(long[] longs) {
        SignedInt64Member type = new SignedInt64Member();
        ArrayStorageSignedInt64<SignedInt64Member> store = new ArrayStorageSignedInt64<SignedInt64Member>(longs.length, type);
        for (int i = 0; i < longs.length; ++i) {
            type.setV(longs[i]);
            store.set((long)i, type);
        }
        return store;
    }

    public static IndexedDataSource<Float32Member> allocateFloats(float[] floats) {
        Float32Member type = new Float32Member();
        ArrayStorageFloat32<Float32Member> store = new ArrayStorageFloat32<Float32Member>(floats.length, type);
        for (int i = 0; i < floats.length; ++i) {
            type.setV(floats[i]);
            store.set((long)i, type);
        }
        return store;
    }

    public static IndexedDataSource<Float64Member> allocateDoubles(double[] doubles) {
        Float64Member type = new Float64Member();
        ArrayStorageFloat64<Float64Member> store = new ArrayStorageFloat64<Float64Member>(doubles.length, type);
        for (int i = 0; i < doubles.length; ++i) {
            type.setV(doubles[i]);
            store.set((long)i, type);
        }
        return store;
    }

    public static IndexedDataSource<BooleanMember> allocateBooleans(boolean[] booleans) {
        BooleanMember type = new BooleanMember();
        ArrayStorageBoolean<BooleanMember> store = new ArrayStorageBoolean<BooleanMember>(booleans.length, type);
        for (int i = 0; i < booleans.length; ++i) {
            type.setV(booleans[i]);
            store.set((long)i, type);
        }
        return store;
    }

    public static IndexedDataSource<UnboundedIntMember> allocateBigIntegers(BigInteger[] bigints) {
        UnboundedIntMember type = new UnboundedIntMember();
        ArrayStorageBigInteger<UnboundedIntMember> store = new ArrayStorageBigInteger<UnboundedIntMember>(bigints.length, type);
        for (int i = 0; i < bigints.length; ++i) {
            type.setV(bigints[i]);
            store.set((long)i, type);
        }
        return store;
    }

    public static IndexedDataSource<HighPrecisionMember> allocateBigDecimals(BigDecimal[] bigdecs) {
        HighPrecisionMember type = new HighPrecisionMember();
        ArrayStorageBigDecimal<HighPrecisionMember> store = new ArrayStorageBigDecimal<HighPrecisionMember>(bigdecs.length, type);
        for (int i = 0; i < bigdecs.length; ++i) {
            type.setV(bigdecs[i]);
            store.set((long)i, type);
        }
        return store;
    }
}

