/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import java.math.BigDecimal;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.BigDecimalCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageBigDecimal<U extends BigDecimalCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageBigDecimal<U>> {
    private final U type;
    private final BigDecimal[] data;

    public ArrayStorageBigDecimal(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageBigDecimal cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.bigDecimalCount())) {
            throw new IllegalArgumentException("ArrayStorageBigDecimal can handle at most " + Integer.MAX_VALUE / type.bigDecimalCount() + " of the type of requested BigDecimal based entities");
        }
        this.type = (BigDecimalCoder)((Allocatable)type).allocate();
        this.data = new BigDecimal[(int)size * type.bigDecimalCount()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = BigDecimal.ZERO;
        }
    }

    @Override
    public void set(long index, U value) {
        value.toBigDecimalArray(this.data, (int)(index * (long)this.type.bigDecimalCount()));
    }

    @Override
    public void get(long index, U value) {
        value.fromBigDecimalArray(this.data, (int)(index * (long)this.type.bigDecimalCount()));
    }

    @Override
    public long size() {
        return this.data.length / this.type.bigDecimalCount();
    }

    @Override
    public ArrayStorageBigDecimal<U> duplicate() {
        ArrayStorageBigDecimal<U> s = new ArrayStorageBigDecimal<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageBigDecimal<U> allocate() {
        return new ArrayStorageBigDecimal<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

