/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import java.math.BigInteger;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.BigIntegerCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageBigInteger<U extends BigIntegerCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageBigInteger<U>> {
    private final U type;
    private final BigInteger[] data;

    public ArrayStorageBigInteger(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageBigInteger cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.bigIntegerCount())) {
            throw new IllegalArgumentException("ArrayStorageBigInteger can handle at most " + Integer.MAX_VALUE / type.bigIntegerCount() + " of the type of requested BigInteger based entities");
        }
        this.type = (BigIntegerCoder)((Allocatable)type).allocate();
        this.data = new BigInteger[(int)size * type.bigIntegerCount()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = BigInteger.ZERO;
        }
    }

    @Override
    public void set(long index, U value) {
        value.toBigIntegerArray(this.data, (int)(index * (long)this.type.bigIntegerCount()));
    }

    @Override
    public void get(long index, U value) {
        value.fromBigIntegerArray(this.data, (int)(index * (long)this.type.bigIntegerCount()));
    }

    @Override
    public long size() {
        return this.data.length / this.type.bigIntegerCount();
    }

    @Override
    public ArrayStorageBigInteger<U> duplicate() {
        ArrayStorageBigInteger<U> s = new ArrayStorageBigInteger<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageBigInteger<U> allocate() {
        return new ArrayStorageBigInteger<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

