/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.BitCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageBit<U extends BitCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageBit<U>> {
    private final U type;
    private final long[] data;
    private final long size;

    public ArrayStorageBit(long size, U type) {
        long maxElements = 137438953408L / (long)type.bitCount();
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageBit cannot handle a negative request");
        }
        if (size > maxElements) {
            throw new IllegalArgumentException("ArrayStorageBit can handle at most " + maxElements + " elements of the given type.");
        }
        int count = (int)(size * (long)type.bitCount() / 64L);
        if (size * (long)type.bitCount() % 64L > 0L) {
            ++count;
        }
        this.type = (BitCoder)((Allocatable)type).allocate();
        this.data = new long[count];
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        long bitIndex = index * (long)this.type.bitCount();
        int bucketStart = (int)(bitIndex / 64L);
        int bucketOffset = (int)(bitIndex % 64L);
        long[] lArray = this.data;
        synchronized (this.data) {
            value.toBitArray(this.data, bucketStart, bucketOffset);
            // ** MonitorExit[var8_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        long bitIndex = index * (long)this.type.bitCount();
        int bucketStart = (int)(bitIndex / 64L);
        int bucketOffset = (int)(bitIndex % 64L);
        long[] lArray = this.data;
        synchronized (this.data) {
            value.fromBitArray(this.data, bucketStart, bucketOffset);
            // ** MonitorExit[var8_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayStorageBit<U> duplicate() {
        ArrayStorageBit<U> s = new ArrayStorageBit<U>(this.size(), this.type);
        long[] lArray = this.data;
        synchronized (this.data) {
            for (int i = 0; i < this.data.length; ++i) {
                s.data[i] = this.data[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return s;
        }
    }

    @Override
    public ArrayStorageBit<U> allocate() {
        return new ArrayStorageBit<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

