/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageBoolean<U extends BooleanCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageBoolean<U>> {
    private final U type;
    private final boolean[] data;

    public ArrayStorageBoolean(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageBoolean cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.booleanCount())) {
            throw new IllegalArgumentException("ArrayStorageBOllean can handle at most " + Integer.MAX_VALUE / type.booleanCount() + " of the type of requested boolean based entities");
        }
        this.type = (BooleanCoder)((Allocatable)type).allocate();
        this.data = new boolean[(int)size * type.booleanCount()];
    }

    @Override
    public void set(long index, U value) {
        value.toBooleanArray(this.data, (int)(index * (long)this.type.booleanCount()));
    }

    @Override
    public void get(long index, U value) {
        value.fromBooleanArray(this.data, (int)(index * (long)this.type.booleanCount()));
    }

    @Override
    public long size() {
        return this.data.length / this.type.booleanCount();
    }

    @Override
    public ArrayStorageBoolean<U> duplicate() {
        ArrayStorageBoolean<U> s = new ArrayStorageBoolean<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageBoolean<U> allocate() {
        return new ArrayStorageBoolean<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

