/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.FloatCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageFloat32<U extends FloatCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageFloat32<U>> {
    private final U type;
    private final float[] data;

    public ArrayStorageFloat32(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageFloat32 cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.floatCount())) {
            throw new IllegalArgumentException("ArrayStorageFloat32 can handle at most " + Integer.MAX_VALUE / type.floatCount() + " of the type of requested float based entities");
        }
        this.type = (FloatCoder)((Allocatable)type).allocate();
        this.data = new float[(int)size * type.floatCount()];
    }

    @Override
    public void set(long index, U value) {
        value.toFloatArray(this.data, (int)(index * (long)this.type.floatCount()));
    }

    @Override
    public void get(long index, U value) {
        value.fromFloatArray(this.data, (int)(index * (long)this.type.floatCount()));
    }

    @Override
    public long size() {
        return this.data.length / this.type.floatCount();
    }

    @Override
    public ArrayStorageFloat32<U> duplicate() {
        ArrayStorageFloat32<U> s = new ArrayStorageFloat32<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageFloat32<U> allocate() {
        return new ArrayStorageFloat32<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

