/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageFloat64<U extends DoubleCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageFloat64<U>> {
    private final U type;
    private final double[] data;

    public ArrayStorageFloat64(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageFloat64 cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.doubleCount())) {
            throw new IllegalArgumentException("ArrayStorageFloat64 can handle at most " + Integer.MAX_VALUE / type.doubleCount() + " of the type of requested double based entities");
        }
        this.type = (DoubleCoder)((Allocatable)type).allocate();
        this.data = new double[(int)size * type.doubleCount()];
    }

    @Override
    public void set(long index, U value) {
        value.toDoubleArray(this.data, (int)(index * (long)this.type.doubleCount()));
    }

    @Override
    public void get(long index, U value) {
        value.fromDoubleArray(this.data, (int)(index * (long)this.type.doubleCount()));
    }

    @Override
    public long size() {
        return this.data.length / this.type.doubleCount();
    }

    @Override
    public ArrayStorageFloat64<U> duplicate() {
        ArrayStorageFloat64<U> s = new ArrayStorageFloat64<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageFloat64<U> allocate() {
        return new ArrayStorageFloat64<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

