/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageGeneric<T extends Algebra<T, U>, U>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageGeneric<T, U>> {
    private final T alg;
    private final Object[] data;

    public ArrayStorageGeneric(long size, T alg) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageGeneric cannot handle a negative request");
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("ArrayStorageGeneric can handle at most 2147483647 objects");
        }
        this.alg = alg;
        this.data = new Object[(int)size];
        int i = 0;
        while ((long)i < size) {
            this.data[i] = alg.construct();
            ++i;
        }
    }

    @Override
    public void set(long index, U value) {
        this.alg.assign().call(value, this.data[(int)index]);
    }

    @Override
    public void get(long index, U value) {
        this.alg.assign().call(this.data[(int)index], value);
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    public ArrayStorageGeneric<T, U> duplicate() {
        ArrayStorageGeneric<T, U> s = new ArrayStorageGeneric<T, U>(this.size(), this.alg);
        for (int i = 0; i < this.data.length; ++i) {
            this.alg.assign().call(this.data[i], s.data[i]);
        }
        return s;
    }

    @Override
    public ArrayStorageGeneric<T, U> allocate() {
        return new ArrayStorageGeneric<T, U>(this.size(), this.alg);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

