/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageSignedInt16<U extends ShortCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageSignedInt16<U>> {
    private final U type;
    private final short[] data;

    public ArrayStorageSignedInt16(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageSignedInt16 cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.shortCount())) {
            throw new IllegalArgumentException("ArrayStorageSignedInt16 can handle at most " + Integer.MAX_VALUE / type.shortCount() + " of the type of requested short based entities");
        }
        this.type = (ShortCoder)((Allocatable)type).allocate();
        this.data = new short[(int)size * type.shortCount()];
    }

    @Override
    public void set(long index, U value) {
        value.toShortArray(this.data, (int)index * this.type.shortCount());
    }

    @Override
    public void get(long index, U value) {
        value.fromShortArray(this.data, (int)index * this.type.shortCount());
    }

    @Override
    public long size() {
        return this.data.length / this.type.shortCount();
    }

    @Override
    public ArrayStorageSignedInt16<U> duplicate() {
        ArrayStorageSignedInt16<U> s = new ArrayStorageSignedInt16<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageSignedInt16<U> allocate() {
        return new ArrayStorageSignedInt16<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

