/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.IntCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageSignedInt32<U extends IntCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageSignedInt32<U>> {
    private final U type;
    private final int[] data;

    public ArrayStorageSignedInt32(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageSignedInt32 cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.intCount())) {
            throw new IllegalArgumentException("ArrayStorageSignedInt32 can handle at most " + Integer.MAX_VALUE / type.intCount() + " of the type of requested int based entities");
        }
        this.type = (IntCoder)((Allocatable)type).allocate();
        this.data = new int[(int)size * type.intCount()];
    }

    @Override
    public void set(long index, U value) {
        value.toIntArray(this.data, (int)(index * (long)this.type.intCount()));
    }

    @Override
    public void get(long index, U value) {
        value.fromIntArray(this.data, (int)(index * (long)this.type.intCount()));
    }

    @Override
    public long size() {
        return this.data.length / this.type.intCount();
    }

    @Override
    public ArrayStorageSignedInt32<U> duplicate() {
        ArrayStorageSignedInt32<U> s = new ArrayStorageSignedInt32<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageSignedInt32<U> allocate() {
        return new ArrayStorageSignedInt32<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

