/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageSignedInt64<U extends LongCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageSignedInt64<U>> {
    private final U type;
    private final long[] data;

    public ArrayStorageSignedInt64(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageSignedInt64 cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.longCount())) {
            throw new IllegalArgumentException("ArrayStorageSignedInt64 can handle at most " + Integer.MAX_VALUE / type.longCount() + " of the type of requested long based entities");
        }
        this.type = (LongCoder)((Allocatable)type).allocate();
        this.data = new long[(int)size * type.longCount()];
    }

    @Override
    public void set(long index, U value) {
        value.toLongArray(this.data, (int)(index * (long)this.type.longCount()));
    }

    @Override
    public void get(long index, U value) {
        value.fromLongArray(this.data, (int)(index * (long)this.type.longCount()));
    }

    @Override
    public long size() {
        return this.data.length / this.type.longCount();
    }

    @Override
    public ArrayStorageSignedInt64<U> duplicate() {
        ArrayStorageSignedInt64<U> s = new ArrayStorageSignedInt64<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageSignedInt64<U> allocate() {
        return new ArrayStorageSignedInt64<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

