/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.array;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayStorageSignedInt8<U extends ByteCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<ArrayStorageSignedInt8<U>> {
    private final U type;
    private final byte[] data;

    public ArrayStorageSignedInt8(long size, U type) {
        if (size < 0L) {
            throw new IllegalArgumentException("ArrayStorageSignedInt8 cannot handle a negative request");
        }
        if (size > (long)(Integer.MAX_VALUE / type.byteCount())) {
            throw new IllegalArgumentException("ArrayStorageSignedInt8 can handle at most " + Integer.MAX_VALUE / type.byteCount() + " of the type of requested byte based entities");
        }
        this.type = (ByteCoder)((Allocatable)type).allocate();
        this.data = new byte[(int)size * type.byteCount()];
    }

    @Override
    public void set(long index, U value) {
        value.toByteArray(this.data, (int)(index * (long)this.type.byteCount()));
    }

    @Override
    public void get(long index, U value) {
        value.fromByteArray(this.data, (int)(index * (long)this.type.byteCount()));
    }

    @Override
    public long size() {
        return this.data.length / this.type.byteCount();
    }

    @Override
    public ArrayStorageSignedInt8<U> duplicate() {
        ArrayStorageSignedInt8<U> s = new ArrayStorageSignedInt8<U>(this.size(), this.type);
        for (int i = 0; i < this.data.length; ++i) {
            s.data[i] = this.data[i];
        }
        return s;
    }

    @Override
    public ArrayStorageSignedInt8<U> allocate() {
        return new ArrayStorageSignedInt8<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

