/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ArrayDataSource<T extends Algebra<T, U>, U>
implements IndexedDataSource<U> {
    private final T algebra;
    private final U[] data;

    public ArrayDataSource(T algebra, U[] data) {
        this.algebra = algebra;
        this.data = data;
    }

    @Override
    public ArrayDataSource<T, U> duplicate() {
        return new ArrayDataSource<T, U>(this.algebra, this.data);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= (long)this.data.length) {
            throw new IllegalArgumentException("index oob");
        }
        this.algebra.assign().call(value, this.data[(int)index]);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= (long)this.data.length) {
            throw new IllegalArgumentException("index oob");
        }
        this.algebra.assign().call(this.data[(int)index], value);
    }

    @Override
    public long size() {
        return this.data.length;
    }

    public static <T extends Algebra<T, U>, U> ArrayDataSource<T, U> construct(T algebra, int numElems) {
        Object[] array = new Object[numElems];
        for (int i = 0; i < numElems; ++i) {
            array[i] = algebra.construct();
        }
        return new ArrayDataSource<T, Object>(algebra, array);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

