/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class BigListDataSource<T extends Algebra<T, U>, U>
implements IndexedDataSource<U> {
    public static long MAX_ITEMS = BigList.MAX_ITEMS;
    private final T algebra;
    private final long size;
    private final BigList<U> data;

    public BigListDataSource(T algebra, long numItems) {
        this.algebra = algebra;
        this.size = numItems;
        this.data = new BigList(numItems);
        for (long i = 0L; i < numItems; ++i) {
            this.data.set(i, algebra.construct());
        }
    }

    @Override
    public BigListDataSource<T, U> duplicate() {
        BigListDataSource<T, U> ds = new BigListDataSource<T, U>(this.algebra, this.size);
        for (long i = 0L; i < this.size; ++i) {
            U v = this.data.get(i);
            ds.set(i, v);
        }
        return ds;
    }

    @Override
    public void set(long index, U value) {
        U v = this.data.get(index);
        this.algebra.assign().call(value, v);
    }

    @Override
    public void get(long index, U value) {
        U v = this.data.get(index);
        this.algebra.assign().call(v, value);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

