/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import java.math.BigInteger;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ConcatenatedDataSource<U>
implements IndexedDataSource<U> {
    private final IndexedDataSource<U> first;
    private final IndexedDataSource<U> second;
    private final long sz;
    private final long firstSz;

    public ConcatenatedDataSource(IndexedDataSource<U> a, IndexedDataSource<U> b) {
        if (BigInteger.valueOf(a.size()).add(BigInteger.valueOf(b.size())).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new IllegalArgumentException("the two input lists are too long to add together");
        }
        this.first = a;
        this.second = b;
        this.firstSz = a.size();
        this.sz = this.firstSz + b.size();
    }

    @Override
    public ConcatenatedDataSource<U> duplicate() {
        return new ConcatenatedDataSource<U>(this.first, this.second);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L) {
            throw new IllegalArgumentException("negative index exception");
        }
        if (index < this.firstSz) {
            this.first.set(index, value);
        } else {
            this.second.set(index - this.firstSz, value);
        }
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L) {
            throw new IllegalArgumentException("negative index exception");
        }
        if (index < this.firstSz) {
            this.first.get(index, value);
        } else {
            this.second.get(index - this.firstSz, value);
        }
    }

    @Override
    public long size() {
        return this.sz;
    }

    @Override
    public StorageConstruction storageType() {
        if (this.first.storageType() == StorageConstruction.MEM_SPARSE && this.second.storageType() == StorageConstruction.MEM_SPARSE) {
            return StorageConstruction.MEM_SPARSE;
        }
        if (this.first.storageType() == StorageConstruction.MEM_VIRTUAL || this.second.storageType() == StorageConstruction.MEM_VIRTUAL) {
            return StorageConstruction.MEM_VIRTUAL;
        }
        if (this.size() <= Integer.MAX_VALUE) {
            return StorageConstruction.MEM_ARRAY;
        }
        return StorageConstruction.MEM_VIRTUAL;
    }
}

