/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.predicate.Predicate;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.int64.SignedInt64Member;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ConditionalDataSource<T extends Algebra<T, U>, U>
implements IndexedDataSource<U> {
    private static final ThreadLocal<SignedInt64Member> tmp64 = new ThreadLocal<SignedInt64Member>(){

        @Override
        protected SignedInt64Member initialValue() {
            return G.INT64.construct();
        }
    };
    private final T algebra;
    private final IndexedDataSource<U> source;
    private final Predicate<U> condition;
    private final IndexedDataSource<SignedInt64Member> indexList;
    private final long sz;

    public ConditionalDataSource(T algebra, IndexedDataSource<U> source, Predicate<U> condition) {
        this.algebra = algebra;
        this.source = source;
        this.condition = condition;
        Object tmp = algebra.construct();
        long count = 0L;
        long srcSize = source.size();
        for (long i = 0L; i < srcSize; ++i) {
            source.get(i, tmp);
            if (!condition.isTrue(tmp)) continue;
            ++count;
        }
        this.sz = count;
        SignedInt64Member val = tmp64.get();
        this.indexList = Storage.allocate(this.sz, val);
        count = 0L;
        for (long i = 0L; i < srcSize; ++i) {
            source.get(i, tmp);
            if (!condition.isTrue(tmp)) continue;
            val.setV(i);
            this.indexList.set(count, val);
            ++count;
        }
    }

    @Override
    public ConditionalDataSource<T, U> duplicate() {
        return new ConditionalDataSource<T, U>(this.algebra, this.source, this.condition);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.sz) {
            throw new IllegalArgumentException("index out of bounds for conditional data source");
        }
        if (!this.condition.isTrue(value)) {
            throw new IllegalArgumentException("inserted values must conform to the condition");
        }
        SignedInt64Member tmp = tmp64.get();
        this.indexList.get(index, tmp);
        this.source.set(tmp.v(), value);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.sz) {
            throw new IllegalArgumentException("index out of bounds for conditional data source");
        }
        SignedInt64Member tmp = tmp64.get();
        this.indexList.get(index, tmp);
        this.source.get(tmp.v(), value);
    }

    @Override
    public long size() {
        return this.sz;
    }

    @Override
    public StorageConstruction storageType() {
        return this.source.storageType();
    }
}

