/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class FixedSizeDataSource<U>
implements IndexedDataSource<U> {
    private final long size;
    private final IndexedDataSource<U> src;

    public FixedSizeDataSource(long size, IndexedDataSource<U> src) {
        if (size < 0L) {
            throw new IllegalArgumentException("negative size not allowed");
        }
        this.size = size;
        this.src = src;
    }

    @Override
    public FixedSizeDataSource<U> duplicate() {
        return new FixedSizeDataSource<U>(this.size, this.src);
    }

    @Override
    public void set(long index, U value) {
        this.src.set(index, value);
    }

    @Override
    public void get(long index, U value) {
        this.src.get(index, value);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public StorageConstruction storageType() {
        return this.src.storageType();
    }
}

