/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import java.util.ArrayList;
import java.util.List;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ListDataSource<T extends Algebra<T, U>, U>
implements IndexedDataSource<U> {
    private final T algebra;
    private final List<U> list;

    public ListDataSource(T algebra, List<U> list) {
        this.algebra = algebra;
        this.list = list;
    }

    @Override
    public ListDataSource<T, U> duplicate() {
        return new ListDataSource<T, U>(this.algebra, this.list);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= (long)this.list.size()) {
            throw new IllegalArgumentException("index oob for ListDataSource");
        }
        U tmp = this.list.get((int)index);
        this.algebra.assign().call(value, tmp);
        this.list.set((int)index, tmp);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= (long)this.list.size()) {
            throw new IllegalArgumentException("index oob for ListDataSource");
        }
        U tmp = this.list.get((int)index);
        this.algebra.assign().call(tmp, value);
    }

    @Override
    public long size() {
        return this.list.size();
    }

    public static <T extends Algebra<T, U>, U> ListDataSource<T, U> construct(T algebra, int numElems) {
        ArrayList array = new ArrayList();
        for (int i = 0; i < numElems; ++i) {
            array.add(algebra.construct());
        }
        return new ListDataSource(algebra, array);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

