/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.bool.BooleanMember;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class MaskedDataSource<U>
implements IndexedDataSource<U> {
    private final IndexedDataSource<U> list;
    private final IndexedDataSource<BooleanMember> mask;
    private final long listSize;
    private final long maskSize;
    private final long trueCount;
    private static final ThreadLocal<BooleanMember> bTmp = new ThreadLocal<BooleanMember>(){

        @Override
        protected BooleanMember initialValue() {
            return G.BOOL.construct();
        }
    };

    public MaskedDataSource(IndexedDataSource<U> list, IndexedDataSource<BooleanMember> mask) {
        this.list = list;
        this.mask = mask;
        this.listSize = list.size();
        long mSz = mask.size();
        this.maskSize = mSz > this.listSize ? this.listSize : mSz;
        if (this.maskSize == 0L) {
            throw new IllegalArgumentException("mask must not be of length 0");
        }
        BooleanMember b = bTmp.get();
        long count = 0L;
        for (long i = 0L; i < this.maskSize; ++i) {
            mask.get(i, b);
            if (!b.v()) continue;
            ++count;
        }
        this.trueCount = count;
    }

    @Override
    public MaskedDataSource<U> duplicate() {
        return new MaskedDataSource<U>(this.list, this.mask);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L) {
            throw new IllegalArgumentException("negative index exception");
        }
        long pos = this.findPosition(index);
        if (pos < 0L) {
            throw new IllegalArgumentException("accessing masked data source off the end");
        }
        this.list.set(pos, value);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L) {
            throw new IllegalArgumentException("negative index exception");
        }
        long pos = this.findPosition(index);
        if (pos < 0L) {
            throw new IllegalArgumentException("accessing masked data source off the end");
        }
        this.list.get(pos, value);
    }

    @Override
    public long size() {
        BooleanMember b = bTmp.get();
        long numFullReps = this.listSize / this.maskSize;
        long sz = numFullReps * this.trueCount;
        long partialMaskSize = this.listSize % this.maskSize;
        for (long i = 0L; i < partialMaskSize; ++i) {
            this.mask.get(i, b);
            if (!b.v()) continue;
            ++sz;
        }
        return sz;
    }

    private long findPosition(long index) {
        BooleanMember b = bTmp.get();
        long numFullReps = index / this.trueCount;
        long pos = numFullReps * this.maskSize;
        long found = 0L;
        long mustFind = index % this.trueCount + 1L;
        long i = 0L;
        while (found < mustFind) {
            this.mask.get(i, b);
            if (b.v()) {
                ++found;
            }
            if (found == mustFind) continue;
            ++i;
        }
        return pos += i;
    }

    @Override
    public StorageConstruction storageType() {
        return this.list.storageType();
    }
}

