/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ProcedurePaddedDataSource<T extends Algebra<T, U>, U>
implements IndexedDataSource<U> {
    private final T algebra;
    private final IndexedDataSource<U> storage;
    private final Procedure2<Long, U> proc;
    private final long sz;
    private final ThreadLocal<U> tmp;

    public ProcedurePaddedDataSource(T alg, IndexedDataSource<U> storage, Procedure2<Long, U> proc) {
        this.algebra = alg;
        this.storage = storage;
        this.proc = proc;
        this.sz = storage.size();
        this.tmp = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return ProcedurePaddedDataSource.this.algebra.construct();
            }
        };
    }

    @Override
    public ProcedurePaddedDataSource<T, U> duplicate() {
        return new ProcedurePaddedDataSource<T, U>(this.algebra, this.storage, this.proc);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.sz) {
            U t = this.tmp.get();
            this.proc.call(index, t);
            if (this.algebra.isNotEqual().call(t, value).booleanValue()) {
                throw new IllegalArgumentException("Out of bounds value does not match out of bounds procedure constraint");
            }
        } else {
            this.storage.set(index, value);
        }
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.storage.size()) {
            this.proc.call(index, value);
        } else {
            this.storage.get(index, value);
        }
    }

    @Override
    public long size() {
        return this.sz;
    }

    @Override
    public StorageConstruction storageType() {
        return this.storage.storageType();
    }
}

