/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ReadOnlyDataSource<U>
implements IndexedDataSource<U> {
    private final IndexedDataSource<U> source;

    public ReadOnlyDataSource(IndexedDataSource<U> src) {
        this.source = src;
    }

    @Override
    public ReadOnlyDataSource<U> duplicate() {
        return new ReadOnlyDataSource<U>(this.source);
    }

    @Override
    public void set(long index, U value) {
        throw new IllegalArgumentException("cannot write to read only data source");
    }

    @Override
    public void get(long index, U value) {
        this.source.get(index, value);
    }

    @Override
    public long size() {
        return this.source.size();
    }

    @Override
    public StorageConstruction storageType() {
        return this.source.storageType();
    }
}

