/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.HighPrecRepresentation;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ReadOnlyHighPrecisionDataSource<T extends Algebra<T, U>, U extends HighPrecRepresentation>
implements IndexedDataSource<HighPrecisionMember> {
    private final T alg;
    private final IndexedDataSource<U> src;
    private final ThreadLocal<U> tmp;

    public ReadOnlyHighPrecisionDataSource(T algebra, IndexedDataSource<U> src) {
        this.alg = algebra;
        this.src = src;
        this.tmp = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return (HighPrecRepresentation)ReadOnlyHighPrecisionDataSource.this.alg.construct();
            }
        };
    }

    @Override
    public ReadOnlyHighPrecisionDataSource<T, U> duplicate() {
        return new ReadOnlyHighPrecisionDataSource<T, U>(this.alg, this.src);
    }

    @Override
    public void set(long index, HighPrecisionMember value) {
        throw new IllegalArgumentException("cannot set a value when using a readonly data source");
    }

    @Override
    public void get(long index, HighPrecisionMember value) {
        HighPrecRepresentation val = (HighPrecRepresentation)this.tmp.get();
        this.src.get(index, val);
        val.toHighPrec(value);
    }

    @Override
    public long size() {
        return this.src.size();
    }

    @Override
    public StorageConstruction storageType() {
        return this.src.storageType();
    }
}

