/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class ReversedDataSource<U>
implements IndexedDataSource<U> {
    private final IndexedDataSource<U> storage;
    private final long sz;

    public ReversedDataSource(IndexedDataSource<U> a) {
        this.storage = a;
        this.sz = a.size();
    }

    @Override
    public ReversedDataSource<U> duplicate() {
        return new ReversedDataSource<U>(this.storage);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.sz) {
            throw new IllegalArgumentException("index out of bounds");
        }
        this.storage.set(this.sz - 1L - index, value);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.sz) {
            throw new IllegalArgumentException("index out of bounds");
        }
        this.storage.get(this.sz - 1L - index, value);
    }

    @Override
    public long size() {
        return this.sz;
    }

    @Override
    public StorageConstruction storageType() {
        return this.storage.storageType();
    }
}

