/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class SequencedDataSource<U>
implements IndexedDataSource<U> {
    private final IndexedDataSource<U> data;
    private final long start;
    private final long stride;
    private final long count;

    public SequencedDataSource(IndexedDataSource<U> data, long start, long stride, long count) {
        this.data = data;
        this.start = start;
        this.stride = stride;
        this.count = count;
        if (count < 0L) {
            throw new IllegalArgumentException("count must be >= 1");
        }
        if (start < 0L || start >= data.size()) {
            throw new IllegalArgumentException("start is outside the bounds of the dataset");
        }
        if (stride == 0L) {
            throw new IllegalArgumentException("stride must be nonzero");
        }
        if (stride > 0L) {
            if (start + stride * (count - 1L) >= data.size()) {
                throw new IllegalArgumentException("the specified sequence reaches beyond the end of the dataset");
            }
        } else if (start + stride * (count - 1L) < 0L) {
            throw new IllegalArgumentException("the specified sequence reaches beyond the beginning of the dataset");
        }
    }

    @Override
    public SequencedDataSource<U> duplicate() {
        return new SequencedDataSource<U>(this.data, this.start, this.stride, this.count);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.count) {
            throw new IllegalArgumentException("index out of bounds");
        }
        this.data.set(this.start + this.stride * index, value);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.count) {
            throw new IllegalArgumentException("index out of bounds");
        }
        this.data.get(this.start + this.stride * index, value);
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public StorageConstruction storageType() {
        return this.data.storageType();
    }
}

