/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class TransformedDataSource<U, W>
implements IndexedDataSource<W> {
    private final IndexedDataSource<U> uCollection;
    private final Algebra<?, U> uAlg;
    private final Procedure2<W, U> wToU;
    private final Procedure2<U, W> uToW;
    private final long sz;
    private final ThreadLocal<U> tmpU = new ThreadLocal<U>(){

        @Override
        protected U initialValue() {
            return TransformedDataSource.this.uAlg.construct();
        }
    };

    public TransformedDataSource(Algebra<?, U> uAlg, IndexedDataSource<U> uCollection, Procedure2<U, W> uToW, Procedure2<W, U> wToU) {
        this.uAlg = uAlg;
        this.uCollection = uCollection;
        this.uToW = uToW;
        this.wToU = wToU;
        this.sz = uCollection.size();
    }

    @Override
    public TransformedDataSource<U, W> duplicate() {
        return new TransformedDataSource<U, W>(this.uAlg, this.uCollection, this.uToW, this.wToU);
    }

    @Override
    public void set(long index, W value) {
        U tmp = this.tmpU.get();
        this.wToU.call(value, tmp);
        this.uCollection.set(index, tmp);
    }

    @Override
    public void get(long index, W value) {
        U tmp = this.tmpU.get();
        this.uCollection.get(index, tmp);
        this.uToW.call(tmp, value);
    }

    @Override
    public long size() {
        return this.sz;
    }

    @Override
    public StorageConstruction storageType() {
        return this.uCollection.storageType();
    }
}

