/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class TrimmedDataSource<U>
implements IndexedDataSource<U> {
    private final IndexedDataSource<U> list;
    private final long first;
    private final long count;

    public TrimmedDataSource(IndexedDataSource<U> list, long first, long count) {
        long listSize = list.size();
        if (first < 0L || count < 0L || first >= listSize || count > listSize || first + count > listSize) {
            throw new IllegalArgumentException("poor definition of first/count/list size");
        }
        this.list = list;
        this.first = first;
        this.count = count;
    }

    @Override
    public TrimmedDataSource<U> duplicate() {
        return new TrimmedDataSource<U>(this.list, this.first, this.count);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L) {
            throw new IllegalArgumentException("negative index exception");
        }
        if (index >= this.size()) {
            throw new IllegalArgumentException("out of bounds index exception");
        }
        this.list.set(this.first + index, value);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L) {
            throw new IllegalArgumentException("negative index exception");
        }
        if (index >= this.size()) {
            throw new IllegalArgumentException("out of bounds index exception");
        }
        this.list.get(this.first + index, value);
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public StorageConstruction storageType() {
        return this.list.storageType();
    }
}

