/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.datasource;

import java.util.ArrayList;
import java.util.List;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.datasource.DataSourceListener;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class WriteNotifyingDataSource<T extends Algebra<T, U>, U>
implements IndexedDataSource<U> {
    private final T algebra;
    private final IndexedDataSource<U> source;
    private final List<DataSourceListener<T, U>> listeners;

    public WriteNotifyingDataSource(T alg, IndexedDataSource<U> src) {
        this.algebra = alg;
        this.source = src;
        this.listeners = new ArrayList<DataSourceListener<T, U>>();
    }

    public void subscribe(DataSourceListener<T, U> listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) != listener) continue;
            return;
        }
        this.listeners.add(listener);
    }

    public void unsubscribe(DataSourceListener<T, U> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public WriteNotifyingDataSource<T, U> duplicate() {
        return new WriteNotifyingDataSource<T, U>(this.algebra, this.source);
    }

    @Override
    public void set(long index, U value) {
        this.source.set(index, value);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).notify(this.algebra, this, index);
        }
    }

    @Override
    public void get(long index, U value) {
        this.source.get(index, value);
    }

    @Override
    public long size() {
        return this.source.size();
    }

    @Override
    public StorageConstruction storageType() {
        return this.source.storageType();
    }
}

