/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public abstract class AbstractFileStorage<U extends Allocatable<U>>
implements IndexedDataSource<U> {
    private long numElements;
    private File file;
    private boolean dirty;
    private long page;
    private long elemsPerPage;

    protected abstract void setLocals(U var1);

    protected abstract int componentCount(U var1);

    protected abstract void allocateBuffer(long var1, U var3);

    protected abstract void writeZeroElement(RandomAccessFile var1) throws IOException;

    protected abstract int elementByteSize();

    protected abstract void writeFromBufferToRaf(RandomAccessFile var1, long var2) throws IOException;

    protected abstract void readFromRafIntoBuffer(RandomAccessFile var1, long var2) throws IOException;

    protected abstract void setBufferValue(long var1, U var3);

    protected abstract void getBufferValue(long var1, U var3);

    protected abstract IndexedDataSource<U> buffer();

    protected abstract void duplicateBuffer(IndexedDataSource<U> var1);

    protected AbstractFileStorage(long numElements, U type) {
        if (numElements < 0L) {
            throw new IllegalArgumentException("num elements must be >= 0");
        }
        int componentsPerType = this.componentCount(type);
        if (componentsPerType <= 0) {
            throw new IllegalArgumentException("components per type (U size) must be >= 1");
        }
        this.setLocals(type);
        this.numElements = numElements;
        this.elemsPerPage = 2048 / componentsPerType;
        if (this.elemsPerPage < 1L) {
            this.elemsPerPage = 1L;
        }
        this.dirty = false;
        this.page = 0L;
        try {
            this.file = File.createTempFile("Storage", ".storage");
            if (!this.file.exists() || this.file.length() == 0L) {
                RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
                long pages = numElements / this.elemsPerPage;
                if (numElements % this.elemsPerPage > 0L) {
                    ++pages;
                }
                for (long p = 0L; p < pages; ++p) {
                    for (long i = 0L; i < this.elemsPerPage; ++i) {
                        this.writeZeroElement(raf);
                    }
                }
                raf.close();
            }
            this.file.deleteOnExit();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.allocateBuffer(this.elemsPerPage, type);
    }

    protected AbstractFileStorage(AbstractFileStorage<U> other, U type) {
        this.setLocals(type);
        try {
            this.numElements = other.numElements;
            this.elemsPerPage = other.elemsPerPage;
            this.dirty = other.dirty;
            this.duplicateBuffer(other.buffer());
            this.page = other.page;
            this.file = File.createTempFile("Storage", ".storage");
            Path FROM = Paths.get(other.file.getAbsolutePath(), new String[0]);
            Path TO = Paths.get(this.file.getAbsolutePath(), new String[0]);
            CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
            Files.copy(FROM, TO, options);
            this.file.deleteOnExit();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        AbstractFileStorage abstractFileStorage = this;
        synchronized (abstractFileStorage) {
            this.load(index);
            this.setBufferValue(index % this.elemsPerPage, value);
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        AbstractFileStorage abstractFileStorage = this;
        synchronized (abstractFileStorage) {
            this.load(index);
            this.getBufferValue(index % this.elemsPerPage, value);
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    private void flush() {
        if (!this.dirty) {
            return;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
            raf.seek(this.page * this.elemsPerPage * (long)this.elementByteSize());
            for (long i = 0L; i < this.elemsPerPage; ++i) {
                this.writeFromBufferToRaf(raf, i);
            }
            raf.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.dirty = false;
    }

    private void load(long index) {
        if (index < 0L || index >= this.numElements) {
            throw new IllegalArgumentException("index out of bounds");
        }
        if (index < this.page * this.elemsPerPage || index >= (this.page + 1L) * this.elemsPerPage) {
            if (this.dirty) {
                this.flush();
            }
            this.page = index / this.elemsPerPage;
            try {
                RandomAccessFile raf = new RandomAccessFile(this.file, "r");
                raf.seek(this.page * this.elemsPerPage * (long)this.elementByteSize());
                for (long i = 0L; i < this.elemsPerPage; ++i) {
                    this.readFromRafIntoBuffer(raf, i);
                }
                raf.close();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }
}

