/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;
import nom.bdezonia.zorbage.type.storage.coder.FloatCoder;
import nom.bdezonia.zorbage.type.storage.coder.IntCoder;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.FileStorageBoolean;
import nom.bdezonia.zorbage.type.storage.file.FileStorageFloat32;
import nom.bdezonia.zorbage.type.storage.file.FileStorageFloat64;
import nom.bdezonia.zorbage.type.storage.file.FileStorageSignedInt16;
import nom.bdezonia.zorbage.type.storage.file.FileStorageSignedInt32;
import nom.bdezonia.zorbage.type.storage.file.FileStorageSignedInt64;
import nom.bdezonia.zorbage.type.storage.file.FileStorageSignedInt8;

public class FileStorage {
    public static <U extends Allocatable<U>> IndexedDataSource<U> allocate(long size, U type) {
        if (type instanceof DoubleCoder) {
            return new FileStorageFloat64<DoubleCoder>(size, (DoubleCoder)((Object)type));
        }
        if (type instanceof FloatCoder) {
            return new FileStorageFloat32<FloatCoder>(size, (FloatCoder)((Object)type));
        }
        if (type instanceof LongCoder) {
            return new FileStorageSignedInt64<LongCoder>(size, (LongCoder)((Object)type));
        }
        if (type instanceof IntCoder) {
            return new FileStorageSignedInt32<IntCoder>(size, (IntCoder)((Object)type));
        }
        if (type instanceof ShortCoder) {
            return new FileStorageSignedInt16<ShortCoder>(size, (ShortCoder)((Object)type));
        }
        if (type instanceof BooleanCoder) {
            return new FileStorageBoolean<BooleanCoder>(size, (BooleanCoder)((Object)type));
        }
        if (type instanceof ByteCoder) {
            return new FileStorageSignedInt8<ByteCoder>(size, (ByteCoder)((Object)type));
        }
        throw new IllegalArgumentException("Unsupported type in FileStorage");
    }
}

