/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageBoolean;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.AbstractFileStorage;

public class FileStorageBoolean<U extends BooleanCoder & Allocatable<U>>
extends AbstractFileStorage<U>
implements Allocatable<FileStorageBoolean<U>> {
    private ArrayStorageBoolean<U> buffer;
    private U type;
    private ThreadLocal<boolean[]> tmpA;
    private ThreadLocal<U> tmpU;

    public FileStorageBoolean(long numElements, U type) {
        super(numElements, (Allocatable)type);
    }

    public FileStorageBoolean(FileStorageBoolean<U> other, U t) {
        super(other, (Allocatable)t);
    }

    @Override
    public FileStorageBoolean<U> duplicate() {
        return new FileStorageBoolean<U>(this, this.type);
    }

    @Override
    public FileStorageBoolean<U> allocate() {
        return new FileStorageBoolean<U>(this.size(), this.type);
    }

    @Override
    protected void setLocals(U t) {
        this.type = (BooleanCoder)((Allocatable)t).allocate();
        this.tmpA = new ThreadLocal<boolean[]>(){

            @Override
            protected boolean[] initialValue() {
                return new boolean[FileStorageBoolean.this.type.booleanCount()];
            }
        };
        this.tmpU = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return (BooleanCoder)((Allocatable)((Object)FileStorageBoolean.this.type)).allocate();
            }
        };
    }

    @Override
    protected void allocateBuffer(long numElements, U type) {
        this.buffer = new ArrayStorageBoolean<U>(numElements, type);
    }

    @Override
    protected void writeZeroElement(RandomAccessFile raf) throws IOException {
        boolean[] arr = this.tmpA.get();
        for (int i = 0; i < arr.length; ++i) {
            raf.writeBoolean(false);
        }
    }

    @Override
    protected void writeFromBufferToRaf(RandomAccessFile raf, long index) throws IOException {
        BooleanCoder value = (BooleanCoder)this.tmpU.get();
        this.buffer.get(index, value);
        boolean[] arr = this.tmpA.get();
        value.toBooleanArray(arr, 0);
        for (int i = 0; i < arr.length; ++i) {
            raf.writeBoolean(arr[i]);
        }
    }

    @Override
    protected void readFromRafIntoBuffer(RandomAccessFile raf, long index) throws IOException {
        boolean[] arr = this.tmpA.get();
        for (int i = 0; i < this.type.booleanCount(); ++i) {
            arr[i] = raf.readBoolean();
        }
        BooleanCoder value = (BooleanCoder)this.tmpU.get();
        value.fromBooleanArray(arr, 0);
        this.buffer.set(index, value);
    }

    @Override
    protected int elementByteSize() {
        return this.type.booleanCount() * 1;
    }

    @Override
    protected void setBufferValue(long idx, U value) {
        this.buffer.set(idx, value);
    }

    @Override
    protected void getBufferValue(long idx, U value) {
        this.buffer.get(idx, value);
    }

    @Override
    protected void duplicateBuffer(IndexedDataSource<U> other) {
        ArrayStorageBoolean otherBuffer = (ArrayStorageBoolean)other;
        this.buffer = otherBuffer.duplicate();
    }

    @Override
    protected IndexedDataSource<U> buffer() {
        return this.buffer;
    }

    @Override
    protected int componentCount(U type) {
        return type.booleanCount();
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

