/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageFloat32;
import nom.bdezonia.zorbage.type.storage.coder.FloatCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.AbstractFileStorage;

public class FileStorageFloat32<U extends FloatCoder & Allocatable<U>>
extends AbstractFileStorage<U>
implements Allocatable<FileStorageFloat32<U>> {
    private ArrayStorageFloat32<U> buffer;
    private U type;
    private ThreadLocal<float[]> tmpA;
    private ThreadLocal<U> tmpU;

    public FileStorageFloat32(long numElements, U type) {
        super(numElements, (Allocatable)type);
    }

    public FileStorageFloat32(FileStorageFloat32<U> other, U t) {
        super(other, (Allocatable)t);
    }

    @Override
    public FileStorageFloat32<U> duplicate() {
        return new FileStorageFloat32<U>(this, this.type);
    }

    @Override
    public FileStorageFloat32<U> allocate() {
        return new FileStorageFloat32<U>(this.size(), this.type);
    }

    @Override
    protected void setLocals(U t) {
        this.type = (FloatCoder)((Allocatable)t).allocate();
        this.tmpA = new ThreadLocal<float[]>(){

            @Override
            protected float[] initialValue() {
                return new float[FileStorageFloat32.this.type.floatCount()];
            }
        };
        this.tmpU = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return (FloatCoder)((Allocatable)((Object)FileStorageFloat32.this.type)).allocate();
            }
        };
    }

    @Override
    protected void allocateBuffer(long numElements, U type) {
        this.buffer = new ArrayStorageFloat32<U>(numElements, type);
    }

    @Override
    protected void writeZeroElement(RandomAccessFile raf) throws IOException {
        float[] arr = this.tmpA.get();
        for (int i = 0; i < arr.length; ++i) {
            raf.writeFloat(0.0f);
        }
    }

    @Override
    protected void writeFromBufferToRaf(RandomAccessFile raf, long index) throws IOException {
        FloatCoder value = (FloatCoder)this.tmpU.get();
        this.buffer.get(index, value);
        float[] arr = this.tmpA.get();
        value.toFloatArray(arr, 0);
        for (int i = 0; i < arr.length; ++i) {
            raf.writeFloat(arr[i]);
        }
    }

    @Override
    protected void readFromRafIntoBuffer(RandomAccessFile raf, long index) throws IOException {
        float[] arr = this.tmpA.get();
        for (int i = 0; i < this.type.floatCount(); ++i) {
            arr[i] = raf.readFloat();
        }
        FloatCoder value = (FloatCoder)this.tmpU.get();
        value.fromFloatArray(arr, 0);
        this.buffer.set(index, value);
    }

    @Override
    protected int elementByteSize() {
        return this.type.floatCount() * 4;
    }

    @Override
    protected void setBufferValue(long idx, U value) {
        this.buffer.set(idx, value);
    }

    @Override
    protected void getBufferValue(long idx, U value) {
        this.buffer.get(idx, value);
    }

    @Override
    protected void duplicateBuffer(IndexedDataSource<U> other) {
        ArrayStorageFloat32 otherBuffer = (ArrayStorageFloat32)other;
        this.buffer = otherBuffer.duplicate();
    }

    @Override
    protected IndexedDataSource<U> buffer() {
        return this.buffer;
    }

    @Override
    protected int componentCount(U type) {
        return type.floatCount();
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

