/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageFloat64;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.AbstractFileStorage;

public class FileStorageFloat64<U extends DoubleCoder & Allocatable<U>>
extends AbstractFileStorage<U>
implements Allocatable<FileStorageFloat64<U>> {
    private ArrayStorageFloat64<U> buffer;
    private U type;
    private ThreadLocal<double[]> tmpA;
    private ThreadLocal<U> tmpU;

    public FileStorageFloat64(long numElements, U type) {
        super(numElements, (Allocatable)type);
    }

    public FileStorageFloat64(FileStorageFloat64<U> other, U t) {
        super(other, (Allocatable)t);
    }

    @Override
    public FileStorageFloat64<U> duplicate() {
        return new FileStorageFloat64<U>(this, this.type);
    }

    @Override
    public FileStorageFloat64<U> allocate() {
        return new FileStorageFloat64<U>(this.size(), this.type);
    }

    @Override
    protected void setLocals(U t) {
        this.type = (DoubleCoder)((Allocatable)t).allocate();
        this.tmpA = new ThreadLocal<double[]>(){

            @Override
            protected double[] initialValue() {
                return new double[FileStorageFloat64.this.type.doubleCount()];
            }
        };
        this.tmpU = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return (DoubleCoder)((Allocatable)((Object)FileStorageFloat64.this.type)).allocate();
            }
        };
    }

    @Override
    protected void allocateBuffer(long numElements, U type) {
        this.buffer = new ArrayStorageFloat64<U>(numElements, type);
    }

    @Override
    protected void writeZeroElement(RandomAccessFile raf) throws IOException {
        double[] arr = this.tmpA.get();
        for (int i = 0; i < arr.length; ++i) {
            raf.writeDouble(0.0);
        }
    }

    @Override
    protected void writeFromBufferToRaf(RandomAccessFile raf, long index) throws IOException {
        DoubleCoder value = (DoubleCoder)this.tmpU.get();
        this.buffer.get(index, value);
        double[] arr = this.tmpA.get();
        value.toDoubleArray(arr, 0);
        for (int i = 0; i < arr.length; ++i) {
            raf.writeDouble(arr[i]);
        }
    }

    @Override
    protected void readFromRafIntoBuffer(RandomAccessFile raf, long index) throws IOException {
        double[] arr = this.tmpA.get();
        for (int i = 0; i < this.type.doubleCount(); ++i) {
            arr[i] = raf.readDouble();
        }
        DoubleCoder value = (DoubleCoder)this.tmpU.get();
        value.fromDoubleArray(arr, 0);
        this.buffer.set(index, value);
    }

    @Override
    protected int elementByteSize() {
        return this.type.doubleCount() * 8;
    }

    @Override
    protected void setBufferValue(long idx, U value) {
        this.buffer.set(idx, value);
    }

    @Override
    protected void getBufferValue(long idx, U value) {
        this.buffer.get(idx, value);
    }

    @Override
    protected void duplicateBuffer(IndexedDataSource<U> other) {
        ArrayStorageFloat64 otherBuffer = (ArrayStorageFloat64)other;
        this.buffer = otherBuffer.duplicate();
    }

    @Override
    protected IndexedDataSource<U> buffer() {
        return this.buffer;
    }

    @Override
    protected int componentCount(U type) {
        return type.doubleCount();
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

