/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageSignedInt16;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.AbstractFileStorage;

public class FileStorageSignedInt16<U extends ShortCoder & Allocatable<U>>
extends AbstractFileStorage<U>
implements Allocatable<FileStorageSignedInt16<U>> {
    private ArrayStorageSignedInt16<U> buffer;
    private U type;
    private ThreadLocal<short[]> tmpA;
    private ThreadLocal<U> tmpU;

    public FileStorageSignedInt16(long numElements, U type) {
        super(numElements, (Allocatable)type);
    }

    public FileStorageSignedInt16(FileStorageSignedInt16<U> other, U t) {
        super(other, (Allocatable)t);
    }

    @Override
    public FileStorageSignedInt16<U> duplicate() {
        return new FileStorageSignedInt16<U>(this, this.type);
    }

    @Override
    public FileStorageSignedInt16<U> allocate() {
        return new FileStorageSignedInt16<U>(this.size(), this.type);
    }

    @Override
    protected void setLocals(U t) {
        this.type = (ShortCoder)((Allocatable)t).allocate();
        this.tmpA = new ThreadLocal<short[]>(){

            @Override
            protected short[] initialValue() {
                return new short[FileStorageSignedInt16.this.type.shortCount()];
            }
        };
        this.tmpU = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return (ShortCoder)((Allocatable)((Object)FileStorageSignedInt16.this.type)).allocate();
            }
        };
    }

    @Override
    protected void allocateBuffer(long numElements, U type) {
        this.buffer = new ArrayStorageSignedInt16<U>(numElements, type);
    }

    @Override
    protected void writeZeroElement(RandomAccessFile raf) throws IOException {
        short[] arr = this.tmpA.get();
        for (int i = 0; i < arr.length; ++i) {
            raf.writeShort(0);
        }
    }

    @Override
    protected void writeFromBufferToRaf(RandomAccessFile raf, long index) throws IOException {
        ShortCoder value = (ShortCoder)this.tmpU.get();
        this.buffer.get(index, value);
        short[] arr = this.tmpA.get();
        value.toShortArray(arr, 0);
        for (int i = 0; i < arr.length; ++i) {
            raf.writeShort(arr[i]);
        }
    }

    @Override
    protected void readFromRafIntoBuffer(RandomAccessFile raf, long index) throws IOException {
        short[] arr = this.tmpA.get();
        for (int i = 0; i < this.type.shortCount(); ++i) {
            arr[i] = raf.readShort();
        }
        ShortCoder value = (ShortCoder)this.tmpU.get();
        value.fromShortArray(arr, 0);
        this.buffer.set(index, value);
    }

    @Override
    protected int elementByteSize() {
        return this.type.shortCount() * 2;
    }

    @Override
    protected void setBufferValue(long idx, U value) {
        this.buffer.set(idx, value);
    }

    @Override
    protected void getBufferValue(long idx, U value) {
        this.buffer.get(idx, value);
    }

    @Override
    protected void duplicateBuffer(IndexedDataSource<U> other) {
        ArrayStorageSignedInt16 otherBuffer = (ArrayStorageSignedInt16)other;
        this.buffer = otherBuffer.duplicate();
    }

    @Override
    protected IndexedDataSource<U> buffer() {
        return this.buffer;
    }

    @Override
    protected int componentCount(U type) {
        return type.shortCount();
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

