/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageSignedInt32;
import nom.bdezonia.zorbage.type.storage.coder.IntCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.AbstractFileStorage;

public class FileStorageSignedInt32<U extends IntCoder & Allocatable<U>>
extends AbstractFileStorage<U>
implements Allocatable<FileStorageSignedInt32<U>> {
    private ArrayStorageSignedInt32<U> buffer;
    private U type;
    private ThreadLocal<int[]> tmpA;
    private ThreadLocal<U> tmpU;

    public FileStorageSignedInt32(long numElements, U type) {
        super(numElements, (Allocatable)type);
    }

    public FileStorageSignedInt32(FileStorageSignedInt32<U> other, U t) {
        super(other, (Allocatable)t);
    }

    @Override
    public FileStorageSignedInt32<U> duplicate() {
        return new FileStorageSignedInt32<U>(this, this.type);
    }

    @Override
    public FileStorageSignedInt32<U> allocate() {
        return new FileStorageSignedInt32<U>(this.size(), this.type);
    }

    @Override
    protected void setLocals(U t) {
        this.type = (IntCoder)((Allocatable)t).allocate();
        this.tmpA = new ThreadLocal<int[]>(){

            @Override
            protected int[] initialValue() {
                return new int[FileStorageSignedInt32.this.type.intCount()];
            }
        };
        this.tmpU = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return (IntCoder)((Allocatable)((Object)FileStorageSignedInt32.this.type)).allocate();
            }
        };
    }

    @Override
    protected void allocateBuffer(long numElements, U type) {
        this.buffer = new ArrayStorageSignedInt32<U>(numElements, type);
    }

    @Override
    protected void writeZeroElement(RandomAccessFile raf) throws IOException {
        int[] arr = this.tmpA.get();
        for (int i = 0; i < arr.length; ++i) {
            raf.writeInt(0);
        }
    }

    @Override
    protected void writeFromBufferToRaf(RandomAccessFile raf, long index) throws IOException {
        IntCoder value = (IntCoder)this.tmpU.get();
        this.buffer.get(index, value);
        int[] arr = this.tmpA.get();
        value.toIntArray(arr, 0);
        for (int i = 0; i < arr.length; ++i) {
            raf.writeInt(arr[i]);
        }
    }

    @Override
    protected void readFromRafIntoBuffer(RandomAccessFile raf, long index) throws IOException {
        int[] arr = this.tmpA.get();
        for (int i = 0; i < this.type.intCount(); ++i) {
            arr[i] = raf.readInt();
        }
        IntCoder value = (IntCoder)this.tmpU.get();
        value.fromIntArray(arr, 0);
        this.buffer.set(index, value);
    }

    @Override
    protected int elementByteSize() {
        return this.type.intCount() * 4;
    }

    @Override
    protected void setBufferValue(long idx, U value) {
        this.buffer.set(idx, value);
    }

    @Override
    protected void getBufferValue(long idx, U value) {
        this.buffer.get(idx, value);
    }

    @Override
    protected void duplicateBuffer(IndexedDataSource<U> other) {
        ArrayStorageSignedInt32 otherBuffer = (ArrayStorageSignedInt32)other;
        this.buffer = otherBuffer.duplicate();
    }

    @Override
    protected IndexedDataSource<U> buffer() {
        return this.buffer;
    }

    @Override
    protected int componentCount(U type) {
        return type.intCount();
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

