/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageSignedInt64;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.AbstractFileStorage;

public class FileStorageSignedInt64<U extends LongCoder & Allocatable<U>>
extends AbstractFileStorage<U>
implements Allocatable<FileStorageSignedInt64<U>> {
    private ArrayStorageSignedInt64<U> buffer;
    private U type;
    private ThreadLocal<long[]> tmpA;
    private ThreadLocal<U> tmpU;

    public FileStorageSignedInt64(long numElements, U type) {
        super(numElements, (Allocatable)type);
    }

    public FileStorageSignedInt64(FileStorageSignedInt64<U> other, U t) {
        super(other, (Allocatable)t);
    }

    @Override
    public FileStorageSignedInt64<U> duplicate() {
        return new FileStorageSignedInt64<U>(this, this.type);
    }

    @Override
    public FileStorageSignedInt64<U> allocate() {
        return new FileStorageSignedInt64<U>(this.size(), this.type);
    }

    @Override
    protected void setLocals(U t) {
        this.type = (LongCoder)((Allocatable)t).allocate();
        this.tmpA = new ThreadLocal<long[]>(){

            @Override
            protected long[] initialValue() {
                return new long[FileStorageSignedInt64.this.type.longCount()];
            }
        };
        this.tmpU = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return (LongCoder)((Allocatable)((Object)FileStorageSignedInt64.this.type)).allocate();
            }
        };
    }

    @Override
    protected void allocateBuffer(long numElements, U type) {
        this.buffer = new ArrayStorageSignedInt64<U>(numElements, type);
    }

    @Override
    protected void writeZeroElement(RandomAccessFile raf) throws IOException {
        long[] arr = this.tmpA.get();
        for (int i = 0; i < arr.length; ++i) {
            raf.writeLong(0L);
        }
    }

    @Override
    protected void writeFromBufferToRaf(RandomAccessFile raf, long index) throws IOException {
        LongCoder value = (LongCoder)this.tmpU.get();
        this.buffer.get(index, value);
        long[] arr = this.tmpA.get();
        value.toLongArray(arr, 0);
        for (int i = 0; i < arr.length; ++i) {
            raf.writeLong(arr[i]);
        }
    }

    @Override
    protected void readFromRafIntoBuffer(RandomAccessFile raf, long index) throws IOException {
        long[] arr = this.tmpA.get();
        for (int i = 0; i < this.type.longCount(); ++i) {
            arr[i] = raf.readLong();
        }
        LongCoder value = (LongCoder)this.tmpU.get();
        value.fromLongArray(arr, 0);
        this.buffer.set(index, value);
    }

    @Override
    protected int elementByteSize() {
        return this.type.longCount() * 8;
    }

    @Override
    protected void setBufferValue(long idx, U value) {
        this.buffer.set(idx, value);
    }

    @Override
    protected void getBufferValue(long idx, U value) {
        this.buffer.get(idx, value);
    }

    @Override
    protected void duplicateBuffer(IndexedDataSource<U> other) {
        ArrayStorageSignedInt64 otherBuffer = (ArrayStorageSignedInt64)other;
        this.buffer = otherBuffer.duplicate();
    }

    @Override
    protected IndexedDataSource<U> buffer() {
        return this.buffer;
    }

    @Override
    protected int componentCount(U type) {
        return type.longCount();
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

