/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.array.ArrayStorageSignedInt8;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.file.AbstractFileStorage;

public class FileStorageSignedInt8<U extends ByteCoder & Allocatable<U>>
extends AbstractFileStorage<U>
implements Allocatable<FileStorageSignedInt8<U>> {
    private ArrayStorageSignedInt8<U> buffer;
    private U type;
    private ThreadLocal<byte[]> tmpA;
    private ThreadLocal<U> tmpU;

    public FileStorageSignedInt8(long numElements, U type) {
        super(numElements, (Allocatable)type);
    }

    public FileStorageSignedInt8(FileStorageSignedInt8<U> other, U t) {
        super(other, (Allocatable)t);
    }

    @Override
    public FileStorageSignedInt8<U> duplicate() {
        return new FileStorageSignedInt8<U>(this, this.type);
    }

    @Override
    public FileStorageSignedInt8<U> allocate() {
        return new FileStorageSignedInt8<U>(this.size(), this.type);
    }

    @Override
    protected void setLocals(U t) {
        this.type = (ByteCoder)((Allocatable)t).allocate();
        this.tmpA = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[FileStorageSignedInt8.this.type.byteCount()];
            }
        };
        this.tmpU = new ThreadLocal<U>(){

            @Override
            protected U initialValue() {
                return (ByteCoder)((Allocatable)((Object)FileStorageSignedInt8.this.type)).allocate();
            }
        };
    }

    @Override
    protected void allocateBuffer(long numElements, U type) {
        this.buffer = new ArrayStorageSignedInt8<U>(numElements, type);
    }

    @Override
    protected void writeZeroElement(RandomAccessFile raf) throws IOException {
        byte[] arr = this.tmpA.get();
        for (int i = 0; i < arr.length; ++i) {
            raf.writeByte(0);
        }
    }

    @Override
    protected void writeFromBufferToRaf(RandomAccessFile raf, long index) throws IOException {
        ByteCoder value = (ByteCoder)this.tmpU.get();
        this.buffer.get(index, value);
        byte[] arr = this.tmpA.get();
        value.toByteArray(arr, 0);
        for (int i = 0; i < arr.length; ++i) {
            raf.writeByte(arr[i]);
        }
    }

    @Override
    protected void readFromRafIntoBuffer(RandomAccessFile raf, long index) throws IOException {
        byte[] arr = this.tmpA.get();
        for (int i = 0; i < this.type.byteCount(); ++i) {
            arr[i] = raf.readByte();
        }
        ByteCoder value = (ByteCoder)this.tmpU.get();
        value.fromByteArray(arr, 0);
        this.buffer.set(index, value);
    }

    @Override
    protected int elementByteSize() {
        return this.type.byteCount() * 1;
    }

    @Override
    protected void setBufferValue(long idx, U value) {
        this.buffer.set(idx, value);
    }

    @Override
    protected void getBufferValue(long idx, U value) {
        this.buffer.get(idx, value);
    }

    @Override
    protected void duplicateBuffer(IndexedDataSource<U> other) {
        ArrayStorageSignedInt8 otherBuffer = (ArrayStorageSignedInt8)other;
        this.buffer = otherBuffer.duplicate();
    }

    @Override
    protected IndexedDataSource<U> buffer() {
        return this.buffer;
    }

    @Override
    protected int componentCount(U type) {
        return type.byteCount();
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

